/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform;

import java.lang.annotation.Annotation;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.CreateImmediately;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.Replace;

public final class AnnotationFactory {
    private static final ApplicationScoped APPLICATION_SCOPED = new ApplicationScoped(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return ApplicationScoped.class;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return obj instanceof ApplicationScoped;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    };
    private static final CreateImmediately CREATE_IMMEDIATELY = new CreateImmediately(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return CreateImmediately.class;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return obj instanceof CreateImmediately;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    };
    private static final Replace REPLACE = new Replace(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return Replace.class;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return obj instanceof Replace;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    };

    private AnnotationFactory() {
    }

    public static ApplicationScoped createApplicationScoped() {
        return APPLICATION_SCOPED;
    }

    public static CreateImmediately createCreateImmediately() {
        return CREATE_IMMEDIATELY;
    }

    public static Replace createReplace() {
        return REPLACE;
    }

    public static Order createOrder(final double order) {
        return new Order(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Order.class;
            }

            @Override
            public double value() {
                return order;
            }

            @Override
            public int hashCode() {
                long bits = Double.doubleToLongBits(this.value());
                int hashOfValue = (int)(bits ^ bits >>> 32);
                return 127 * "value".hashCode() ^ hashOfValue;
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof Order)) {
                    return false;
                }
                Order other = (Order)obj;
                return Double.doubleToLongBits(this.value()) == Double.doubleToLongBits(other.value());
            }
        };
    }
}

