/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util.visitor;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.visitor.IBreadthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.ITreeTraversal;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;

public class BreadthFirstTraversal<T>
implements ITreeTraversal<T> {
    private final IBreadthFirstTreeVisitor<T> m_visitor;
    private final Function<T, Collection<? extends T>> m_childrenSupplier;

    protected BreadthFirstTraversal(IBreadthFirstTreeVisitor<T> visitor, Function<T, Collection<? extends T>> childrenSupplier) {
        this.m_visitor = visitor;
        this.m_childrenSupplier = childrenSupplier;
    }

    @Override
    public TreeVisitResult traverse(T root) {
        Assertions.assertNotNull(root);
        ArrayDeque<P_BreadthFirstNode<T>> dek = new ArrayDeque<P_BreadthFirstNode<T>>();
        HashSet alreadyEnqueued = new HashSet();
        this.enqueue(dek, alreadyEnqueued, root, 0, 0);
        while (!dek.isEmpty()) {
            P_BreadthFirstNode node = (P_BreadthFirstNode)dek.poll();
            TreeVisitResult nextAction = this.m_visitor.visit(node.m_element, node.m_level, node.m_index);
            if (nextAction == TreeVisitResult.TERMINATE) {
                return TreeVisitResult.TERMINATE;
            }
            if (nextAction == TreeVisitResult.SKIP_SIBLINGS) {
                this.removeQueuedSiblings(dek, node.m_level);
            }
            if (nextAction == TreeVisitResult.SKIP_SUBTREE) continue;
            this.enqueueChildren(dek, alreadyEnqueued, node);
        }
        return TreeVisitResult.CONTINUE;
    }

    private void enqueueChildren(Deque<P_BreadthFirstNode<T>> dek, Set<T> alreadyEnqueued, P_BreadthFirstNode<T> node) {
        Collection<T> children = this.m_childrenSupplier.apply(((P_BreadthFirstNode)node).m_element);
        if (CollectionUtility.isEmpty(children)) {
            return;
        }
        int i = 0;
        for (T child : children) {
            if (child == null) continue;
            this.enqueue(dek, alreadyEnqueued, child, ((P_BreadthFirstNode)node).m_level + 1, i);
            ++i;
        }
    }

    protected void enqueue(Deque<P_BreadthFirstNode<T>> dek, Set<T> alreadyEnqueued, T element, int level, int index) {
        if (alreadyEnqueued.contains(element)) {
            return;
        }
        P_BreadthFirstNode<T> e = new P_BreadthFirstNode<T>(element, level, index);
        dek.addLast(e);
        alreadyEnqueued.add(element);
    }

    protected void removeQueuedSiblings(Deque<P_BreadthFirstNode<T>> dek, int level) {
        Iterator<P_BreadthFirstNode<T>> iterator = dek.iterator();
        while (iterator.hasNext()) {
            P_BreadthFirstNode<T> siblingCandidate = iterator.next();
            if (((P_BreadthFirstNode)siblingCandidate).m_index > 0) {
                iterator.remove();
                continue;
            }
            return;
        }
    }

    protected static class P_BreadthFirstNode<T> {
        private final int m_level;
        private final T m_element;
        private final int m_index;

        protected P_BreadthFirstNode(T element, int level, int index) {
            this.m_element = element;
            this.m_level = level;
            this.m_index = index;
        }
    }
}

