/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.date.DateFormatProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtility {
    public static final long DAY_MILLIS = 86400000L;
    private static final Logger LOG = LoggerFactory.getLogger(DateUtility.class);
    private static final List<String> SUN_WEEKEND_DAYS_COUNTRIES = Arrays.asList("GQ", "IN", "TH", "UG");
    private static final List<String> FRY_WEEKEND_DAYS_COUNTRIES = Arrays.asList("DJ", "IR");
    private static final List<String> FRY_SUN_WEEKEND_DAYS_COUNTRIES = Arrays.asList("BN");
    private static final List<String> THU_FRY_WEEKEND_DAYS_COUNTRIES = Arrays.asList("AF");
    private static final List<String> FRY_SAT_WEEKEND_DAYS_COUNTRIES = Arrays.asList("AE", "DZ", "BH", "BD", "EG", "IQ", "IL", "JO", "KW", "LY", "MV", "MR", "OM", "PS", "QA", "SA", "SD", "SY", "YE");

    private DateUtility() {
    }

    public static String formatDate(Date d) {
        if (d == null) {
            return "";
        }
        Locale loc = NlsLocale.get();
        return BEANS.get(DateFormatProvider.class).getDateInstance(2, loc).format(d);
    }

    public static String formatTime(Date d) {
        if (d == null) {
            return "";
        }
        Locale loc = NlsLocale.get();
        return BEANS.get(DateFormatProvider.class).getTimeInstance(3, loc).format(d);
    }

    public static String formatDateTime(Date d) {
        if (d == null) {
            return "";
        }
        Locale loc = NlsLocale.get();
        return BEANS.get(DateFormatProvider.class).getDateTimeInstance(3, 3, loc).format(d);
    }

    public static String format(Date d, String pattern) {
        if (d == null || !StringUtility.hasText(pattern)) {
            return "";
        }
        Locale loc = NlsLocale.get();
        return new SimpleDateFormat(pattern, loc).format(d);
    }

    public static Date parse(String s, String pattern) {
        if (s == null) {
            return null;
        }
        try {
            Locale loc = NlsLocale.get();
            SimpleDateFormat df = new SimpleDateFormat(pattern, loc);
            df.setLenient(false);
            return df.parse(s);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("parse(\"" + s + "\",\"" + pattern + "\") failed", e);
        }
    }

    public static boolean isValidDate(String s, String pattern) {
        try {
            DateUtility.parse(s, pattern);
            return true;
        }
        catch (IllegalArgumentException e) {
            LOG.debug("could not parse date from given text [s='{}',pattern='{}']", new Object[]{s, pattern, e});
            return false;
        }
    }

    public static Date addMilliseconds(Date d, int milliseconds) {
        return DateUtility.addTime(d, 14, milliseconds);
    }

    public static Date addSeconds(Date d, int seconds) {
        return DateUtility.addTime(d, 13, seconds);
    }

    public static Date addMinutes(Date d, int minutes) {
        return DateUtility.addTime(d, 12, minutes);
    }

    public static Date addHours(Date d, int hours) {
        return DateUtility.addTime(d, 11, hours);
    }

    public static Date addTime(Date d, int field, int amount) {
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(field, amount);
        return cal.getTime();
    }

    public static Date addDays(Date d, double count) {
        if (d == null) {
            return null;
        }
        int sign = 1;
        if (count < 0.0) {
            count = -count;
            sign = -1;
        }
        double roundingFactor = sign > 0 ? 4.0E-6 : 1.7E-6;
        int sec = (int)((count + roundingFactor) * 3600.0 * 24.0);
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(5, sign * (sec / 3600 / 24));
        cal.add(11, sign * (sec / 3600 % 24));
        cal.add(12, sign * (sec / 60 % 60));
        cal.add(13, sign * (sec % 60));
        return cal.getTime();
    }

    public static Date addMonths(Date d, int count) {
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(2, count);
        return cal.getTime();
    }

    public static Date addYears(Date d, int count) {
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(1, count);
        return cal.getTime();
    }

    public static int getWeekday(Date d) {
        if (d == null) {
            return -1;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        int w = cal.get(7);
        return w;
    }

    public static Date truncDate(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        DateUtility.truncCalendar(c);
        return c.getTime();
    }

    public static Date truncDateToHour(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        DateUtility.truncCalendarToHour(c);
        return c.getTime();
    }

    public static Date truncDateToMinute(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date truncDateToSecond(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date truncDateToWeek(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        DateUtility.truncCalendarToWeek(c, -1);
        return c.getTime();
    }

    public static Date truncDateToIsoWeek(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        DateUtility.truncCalendarToIsoWeek(c, -1);
        return c.getTime();
    }

    public static Date truncDateToMonth(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        DateUtility.truncCalendarToMonth(c);
        return c.getTime();
    }

    public static Date truncDateToYear(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        DateUtility.truncCalendarToYear(c);
        return c.getTime();
    }

    public static Date truncDateToHalfYear(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        DateUtility.truncCalendarToHalfYear(c);
        return c.getTime();
    }

    public static Date truncDateToQuarter(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        DateUtility.truncCalendarToQuarter(c);
        return c.getTime();
    }

    public static void truncCalendar(Calendar c) {
        if (c == null) {
            return;
        }
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }

    public static void truncCalendarToWeek(Calendar c, int adjustIncrement) {
        DateUtility.truncCalendarToWeek(c, adjustIncrement, Calendar.getInstance().getFirstDayOfWeek());
    }

    public static void truncCalendarToIsoWeek(Calendar c, int adjustIncrement) {
        DateUtility.truncCalendarToWeek(c, adjustIncrement, 2);
    }

    public static void truncCalendarToWeek(Calendar c, int adjustIncrement, int firstDayOfWeek) {
        if (c == null) {
            return;
        }
        if (adjustIncrement < -1) {
            adjustIncrement = -1;
        }
        if (adjustIncrement > 1) {
            adjustIncrement = 1;
        }
        if (adjustIncrement == 0) {
            adjustIncrement = -1;
        }
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        while (c.get(7) != firstDayOfWeek) {
            c.add(5, adjustIncrement);
        }
    }

    public static void truncCalendarToMonth(Calendar c) {
        if (c == null) {
            return;
        }
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }

    public static void truncCalendarToYear(Calendar c) {
        if (c == null) {
            return;
        }
        c.set(2, 0);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }

    public static void truncCalendarToHalfYear(Calendar c) {
        if (c == null) {
            return;
        }
        int month = c.get(2);
        DateUtility.truncCalendarToYear(c);
        if (month >= 6) {
            c.set(2, 6);
        }
    }

    public static void truncCalendarToQuarter(Calendar c) {
        if (c == null) {
            return;
        }
        int month = c.get(2);
        DateUtility.truncCalendarToYear(c);
        int quarterMonth = 0;
        switch (month) {
            case 3: 
            case 4: 
            case 5: {
                quarterMonth = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                quarterMonth = 6;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                quarterMonth = 9;
            }
        }
        if (quarterMonth != 0) {
            c.set(2, quarterMonth);
        }
    }

    public static void truncCalendarToHour(Calendar c) {
        if (c == null) {
            return;
        }
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }

    public static boolean isInRange(Date minDate, Date d, Date maxDate) {
        if (d == null || minDate == null || maxDate == null) {
            return false;
        }
        return minDate.compareTo(d) <= 0 && d.compareTo(maxDate) <= 0;
    }

    public static boolean intersects(Date fromDate, Date toDate, Date minDate, Date maxDate) {
        if (minDate == null || maxDate == null) {
            return false;
        }
        if (fromDate == null && toDate == null) {
            return false;
        }
        if (fromDate == null) {
            return toDate.compareTo(minDate) >= 0;
        }
        if (toDate == null) {
            return fromDate.compareTo(maxDate) <= 0;
        }
        return fromDate.compareTo(maxDate) <= 0 && toDate.compareTo(minDate) >= 0;
    }

    public static boolean isInDateRange(Date minDate, Date d, Date maxDate) {
        return DateUtility.isInRange(DateUtility.truncDate(minDate), DateUtility.truncDate(d), DateUtility.truncDate(maxDate));
    }

    public static Date nextDay(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.add(5, 1);
        Date dNew = c.getTime();
        return dNew;
    }

    public static Date max(Date ... a) {
        Date max = null;
        Date[] dateArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Date d = dateArray[n2];
            if (d != null) {
                if (max == null) {
                    max = d;
                } else if (d.compareTo(max) > 0) {
                    max = d;
                }
            }
            ++n2;
        }
        return max;
    }

    public static Date min(Date ... a) {
        Date min = null;
        Date[] dateArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Date d = dateArray[n2];
            if (d != null) {
                if (min == null) {
                    min = d;
                } else if (d.compareTo(min) < 0) {
                    min = d;
                }
            }
            ++n2;
        }
        return min;
    }

    public static boolean equals(Date a, Date b) {
        return a == b || a != null && b != null && a.compareTo(b) == 0;
    }

    public static boolean isSameDay(Date a, Date b) {
        a = DateUtility.truncDate(a);
        b = DateUtility.truncDate(b);
        return DateUtility.equals(a, b);
    }

    public static boolean isSameMonth(Date d1, Date d2) {
        Calendar c = Calendar.getInstance();
        c.setTime(d1);
        int m1 = c.get(2);
        c.setTime(d2);
        int m2 = c.get(2);
        return m1 == m2;
    }

    public static boolean isWeekend(Date d) {
        return DateUtility.isWeekend(d, NlsLocale.get());
    }

    public static boolean isWeekend(Date d, Locale locale) {
        int[] weekendDays;
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        int dayOfWeek = c.get(7);
        int[] nArray = weekendDays = DateUtility.getWeekendDays(locale);
        int n = weekendDays.length;
        int n2 = 0;
        while (n2 < n) {
            int weekendDay = nArray[n2];
            if (dayOfWeek == weekendDay) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static int[] getWeekendDays(Locale locale) {
        if (THU_FRY_WEEKEND_DAYS_COUNTRIES.contains(locale.getCountry())) {
            return new int[]{5, 6};
        }
        if (FRY_SUN_WEEKEND_DAYS_COUNTRIES.contains(locale.getCountry())) {
            return new int[]{6, 1};
        }
        if (FRY_WEEKEND_DAYS_COUNTRIES.contains(locale.getCountry())) {
            return new int[]{6};
        }
        if (SUN_WEEKEND_DAYS_COUNTRIES.contains(locale.getCountry())) {
            return new int[]{1};
        }
        if (FRY_SAT_WEEKEND_DAYS_COUNTRIES.contains(locale.getCountry())) {
            return new int[]{6, 7};
        }
        return new int[]{7, 1};
    }

    public static Date convertCalendar(Calendar c) {
        if (c == null) {
            return null;
        }
        return new Date(c.getTimeInMillis());
    }

    public static Calendar convertDate(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c;
    }

    public static Date toUtilDate(Date d) {
        if (d != null && d.getClass() != Date.class) {
            d = new Date(d.getTime());
        }
        return d;
    }

    public static Date createDateTime(Date date, Date time) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(time);
        cal1.set(11, cal2.get(11));
        cal1.set(12, cal2.get(12));
        cal1.set(13, cal2.get(13));
        cal1.set(14, cal2.get(14));
        return cal1.getTime();
    }

    public static Date convertDoubleTimeToDate(Number d) {
        if (d == null) {
            return null;
        }
        int m = d.doubleValue() < 0.0 ? (int)((long)(d.doubleValue() * 8.64E7 - 0.5) % 86400000L) : (int)((long)(d.doubleValue() * 8.64E7 + 0.5) % 86400000L);
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(14, m % 1000);
        c.set(13, (m /= 1000) % 60);
        c.set(12, (m /= 60) % 60);
        c.set(11, (m /= 60) % 24);
        if (m < 0) {
            c.add(5, 1);
        }
        return c.getTime();
    }

    public static Double convertDateToDoubleTime(Date time) {
        if (time == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(time);
        double t = ((c.get(11) * 60 + c.get(12)) * 60 + c.get(13)) * 1000 + c.get(14);
        Double d = t / 8.64E7;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    public static int getDaysBetween(Date start, Date end) {
        if (start == null || end == null) {
            return -1;
        }
        Calendar startDate = DateUtility.convertDate(start);
        DateUtility.truncCalendar(startDate);
        Calendar endDate = DateUtility.convertDate(end);
        DateUtility.truncCalendar(endDate);
        long endL = endDate.getTimeInMillis() + (long)endDate.getTimeZone().getOffset(endDate.getTimeInMillis());
        long startL = startDate.getTimeInMillis() + (long)startDate.getTimeZone().getOffset(startDate.getTimeInMillis());
        int numDays = (int)((endL - startL) / 86400000L);
        return Math.abs(numDays);
    }
}

