/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util.date;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.scout.rt.platform.util.date.DateUtility;
import org.eclipse.scout.rt.platform.util.date.IDateProvider;

public class DateProvider
implements IDateProvider {
    protected Date getDate() {
        return new Date();
    }

    @Override
    public long currentUTCMillis() {
        return this.getDate().getTime();
    }

    @Override
    public Date currentMillis() {
        return this.getDate();
    }

    @Override
    public Date currentSeconds() {
        return DateUtility.truncDateToSecond(this.getDate());
    }

    @Override
    public Date currentDay() {
        return DateUtility.truncDate(this.getDate());
    }

    @Override
    public Date currentMonth() {
        return DateUtility.truncDateToMonth(this.getDate());
    }

    @Override
    public Date currentWeek() {
        return DateUtility.truncDateToWeek(this.getDate());
    }

    @Override
    public Date currentYear() {
        return DateUtility.truncDateToYear(this.getDate());
    }

    @Override
    public TimeZone currentTimeZone() {
        return TimeZone.getDefault();
    }

    @Override
    public Calendar currentCalendar() {
        return Calendar.getInstance();
    }
}

