/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util.date;

import java.text.DateFormat;
import java.util.Locale;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.StringUtility;

@ApplicationScoped
public class DateFormatProvider {
    public static final int PATTERN_STYLE_ISOLATED_DATE = 1;
    public static final int PATTERN_STYLE_ISOLATED_TIME = 2;

    public Locale[] getAvailableLocales() {
        return DateFormat.getAvailableLocales();
    }

    public DateFormat getTimeInstance(int style, Locale locale) {
        return DateFormat.getTimeInstance(style, locale);
    }

    public DateFormat getDateInstance(int style, Locale locale) {
        return DateFormat.getDateInstance(style, locale);
    }

    public DateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale locale) {
        return DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
    }

    public String getDateFormatPattern(int patternStyle, Locale locale) {
        switch (patternStyle) {
            case 1: {
                return this.getIsolatedDateFormatPattern(locale);
            }
            case 2: {
                return this.getIsolatedTimeFormatPattern(locale);
            }
        }
        throw new IllegalArgumentException("Illegal patternStyle " + patternStyle);
    }

    protected String getIsolatedDateFormatPattern(Locale locale) {
        String localeName;
        if (locale == null) {
            locale = NlsLocale.get();
        }
        if ((localeName = StringUtility.emptyIfNull(locale.toLanguageTag()).toLowerCase()).startsWith("en-gb") || localeName.startsWith("nl-be")) {
            return "dd/MM/yyyy";
        }
        if (localeName.startsWith("fr-ch") || localeName.startsWith("it-ch")) {
            return "dd.MM.yyyy";
        }
        if (localeName.startsWith("cs") || localeName.startsWith("fi")) {
            return "d.M.yyyy";
        }
        if (localeName.startsWith("el")) {
            return "d/M/yyyy";
        }
        if (localeName.startsWith("fa") || localeName.startsWith("ja")) {
            return "yyyy/MM/dd";
        }
        if (localeName.startsWith("hu")) {
            return "yyyy.MM.dd";
        }
        if (localeName.startsWith("zh")) {
            return "yyyy-MM-dd";
        }
        if (localeName.startsWith("no") || localeName.startsWith("pl") || localeName.startsWith("rs") || localeName.startsWith("ru") || localeName.startsWith("sr") || localeName.startsWith("tr") || localeName.startsWith("uk") || localeName.startsWith("me") || localeName.startsWith("mk") || localeName.startsWith("et") || localeName.startsWith("de") || localeName.startsWith("bs")) {
            return "dd.MM.yyyy";
        }
        if (localeName.startsWith("es") || localeName.startsWith("ca") || localeName.startsWith("it") || localeName.startsWith("fr") || localeName.startsWith("gl") || localeName.startsWith("vi")) {
            return "dd/MM/yyyy";
        }
        if (localeName.startsWith("nl")) {
            return "dd-MM-yyyy";
        }
        return "MM/dd/yyyy";
    }

    protected String getIsolatedTimeFormatPattern(Locale locale) {
        String localeName;
        if (locale == null) {
            locale = NlsLocale.get();
        }
        if ((localeName = StringUtility.emptyIfNull(locale.toLanguageTag()).toLowerCase()).startsWith("en")) {
            return "h:mm a";
        }
        return "HH:mm";
    }
}

