/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimisticLock {
    private static final Logger LOG = LoggerFactory.getLogger(OptimisticLock.class);
    private final AtomicInteger m_lockCount = new AtomicInteger(0);

    public synchronized boolean acquire() {
        int count = this.m_lockCount.incrementAndGet();
        if (count == 1) {
            return true;
        }
        if (count > 10) {
            LOG.warn("potential programming problem; lock was 10 times acquired and not released", (Throwable)new Exception("origin"));
        }
        return false;
    }

    public void release() {
        this.m_lockCount.decrementAndGet();
    }

    public boolean isAcquired() {
        return this.m_lockCount.get() > 0;
    }

    public boolean isReleased() {
        return !this.isAcquired();
    }
}

