/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util.collection;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.collection.ITransformer;

public class TransformingSet<F, T>
extends AbstractSet<T>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final Set<F> m_wrappedSet;
    private final ITransformer<T, F> m_extToIntTransformer;

    public TransformingSet(Set<F> sourceSet, ITransformer<T, F> function) {
        this.m_wrappedSet = Assertions.assertNotNull(sourceSet);
        this.m_extToIntTransformer = Assertions.assertNotNull(function);
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<F> inner = this.m_wrappedSet.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return inner.hasNext();
            }

            @Override
            public T next() {
                return TransformingSet.this.m_extToIntTransformer.revert(inner.next());
            }

            @Override
            public void remove() {
                inner.remove();
            }
        };
    }

    @Override
    public int size() {
        return this.m_wrappedSet.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.m_wrappedSet.contains(this.m_extToIntTransformer.transform(o));
    }

    @Override
    public boolean isEmpty() {
        return this.m_wrappedSet.isEmpty();
    }

    @Override
    public void clear() {
        this.m_wrappedSet.clear();
    }

    @Override
    public boolean add(T e) {
        return this.m_wrappedSet.add(this.m_extToIntTransformer.transform(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.m_wrappedSet.remove(this.m_extToIntTransformer.transform(o));
    }
}

