/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.OrderedComparator;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public class OrderedCollection<ORDERED extends IOrdered>
implements Iterable<ORDERED> {
    public static final double DEFAULT_EMPTY_ORDER = 0.0;
    private final LinkedList<ORDERED> m_orderedObjects = new LinkedList();
    private final Comparator<? super ORDERED> m_comparator = new OrderedComparator();

    public int size() {
        return this.m_orderedObjects.size();
    }

    public boolean isEmpty() {
        return this.m_orderedObjects.isEmpty();
    }

    public boolean contains(Object o) {
        return this.m_orderedObjects.contains(o);
    }

    @Override
    public Iterator<ORDERED> iterator() {
        return this.m_orderedObjects.iterator();
    }

    public boolean addOrdered(ORDERED o) {
        if (o == null) {
            return false;
        }
        return this.m_orderedObjects.add(o);
    }

    public boolean addAllOrdered(Collection<? extends ORDERED> c) {
        if (c == null) {
            return false;
        }
        boolean changed = false;
        for (IOrdered o : c) {
            changed |= this.addOrdered(o);
        }
        return changed;
    }

    public boolean addOrdered(ORDERED o, double order) {
        if (o == null) {
            return false;
        }
        o.setOrder(order);
        return this.addOrdered(o);
    }

    public boolean remove(Object o) {
        return this.m_orderedObjects.remove(o);
    }

    public boolean removeAll(Collection<?> c) {
        if (CollectionUtility.isEmpty(c)) {
            return false;
        }
        return this.m_orderedObjects.removeAll(c);
    }

    public void clear() {
        this.m_orderedObjects.clear();
    }

    public ORDERED get(int index) {
        return this.getReferenceObjectAt(index);
    }

    public boolean addFirst(ORDERED o) {
        if (o == null) {
            return false;
        }
        if (this.m_orderedObjects.isEmpty()) {
            return this.addOrdered(o, 0.0);
        }
        this.ensureSorted();
        IOrdered first = (IOrdered)this.m_orderedObjects.getFirst();
        return this.addOrdered(o, first.getOrder() - 1000.0);
    }

    private void ensureSorted() {
        this.m_orderedObjects.sort(this.m_comparator);
    }

    public boolean addLast(ORDERED o) {
        if (o == null) {
            return false;
        }
        if (this.m_orderedObjects.isEmpty()) {
            return this.addOrdered(o, 0.0);
        }
        this.ensureSorted();
        IOrdered last = (IOrdered)this.m_orderedObjects.getLast();
        return this.addOrdered(o, last.getOrder() + 1000.0);
    }

    public boolean addBefore(ORDERED o, ORDERED reference) {
        if (o == null) {
            return false;
        }
        if (reference == null) {
            throw new IllegalArgumentException("reference must not be null.");
        }
        if (!this.m_orderedObjects.contains(reference)) {
            throw new IllegalArgumentException("reference object is not part of this ordered collection.");
        }
        ORDERED lower = this.getAdjacentObject(reference, true);
        if (lower == null) {
            return this.addFirst(o);
        }
        return this.insertAfter(Collections.singleton(o), lower, lower.getOrder(), (reference.getOrder() - lower.getOrder()) / 2.0);
    }

    public boolean addAfter(ORDERED o, ORDERED reference) {
        if (o == null) {
            return false;
        }
        if (reference == null) {
            throw new IllegalArgumentException("reference must not be null.");
        }
        if (!this.m_orderedObjects.contains(reference)) {
            throw new IllegalArgumentException("reference object is not part of this ordered collection.");
        }
        ORDERED higher = this.getAdjacentObject(reference, false);
        if (higher == null) {
            return this.addLast(o);
        }
        return this.insertAfter(Collections.singleton(o), reference, higher.getOrder(), (reference.getOrder() - higher.getOrder()) / 2.0);
    }

    public boolean addAt(ORDERED o, int index) {
        if (o == null) {
            return false;
        }
        if (index < 0) {
            throw new IllegalArgumentException("index must not be negative.");
        }
        if (index > this.size()) {
            throw new IllegalArgumentException("index out of bounds.");
        }
        if (index == 0) {
            return this.addFirst(o);
        }
        if (index == this.size()) {
            return this.addLast(o);
        }
        ORDERED reference = this.getReferenceObjectAt(index);
        return this.addBefore(o, reference);
    }

    public ORDERED removeAt(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException("index out of bounds.");
        }
        this.ensureSorted();
        int i = 0;
        Iterator it = this.m_orderedObjects.iterator();
        while (it.hasNext()) {
            IOrdered reference = (IOrdered)it.next();
            if (i == index) {
                it.remove();
                return (ORDERED)reference;
            }
            ++i;
        }
        return null;
    }

    public List<ORDERED> getOrderedList() {
        ArrayList<IOrdered> list = new ArrayList<IOrdered>(this.size());
        IOrdered prev = null;
        boolean unsorted = false;
        boolean first = true;
        for (IOrdered next : this.m_orderedObjects) {
            list.add(next);
            if (unsorted) continue;
            if (!first) {
                unsorted = this.m_comparator.compare(prev, next) > 0;
            }
            first = false;
            prev = next;
        }
        if (unsorted) {
            list.sort(this.m_comparator);
        }
        return list;
    }

    public boolean addBefore(ORDERED o, Class<? extends ORDERED> referenceClass) {
        if (o == null) {
            return false;
        }
        if (referenceClass == null) {
            throw new IllegalArgumentException("referenceClass must not be null.");
        }
        ORDERED reference = this.getReferenceObjectByClass(referenceClass);
        return this.addBefore(o, reference);
    }

    public boolean addAfter(ORDERED o, Class<? extends ORDERED> referenceClass) {
        if (o == null) {
            return false;
        }
        if (referenceClass == null) {
            throw new IllegalArgumentException("referenceClass must not be null.");
        }
        ORDERED reference = this.getReferenceObjectByClass(referenceClass);
        return this.addAfter(o, reference);
    }

    public boolean addAllBefore(Collection<? extends ORDERED> objectToAdd, Class<? extends ORDERED> referenceClass) {
        ArrayList<ORDERED> cleanObjects = CollectionUtility.arrayListWithoutNullElements(objectToAdd);
        if (cleanObjects.isEmpty()) {
            return false;
        }
        if (referenceClass == null) {
            throw new IllegalArgumentException("referenceClass must not be null.");
        }
        ORDERED reference = this.getReferenceObjectByClass(referenceClass);
        return this.addAllBefore(cleanObjects, reference);
    }

    public boolean addAllAfter(Collection<? extends ORDERED> objectToAdd, Class<? extends ORDERED> referenceClass) {
        ArrayList<ORDERED> cleanObjects = CollectionUtility.arrayListWithoutNullElements(objectToAdd);
        if (cleanObjects.isEmpty()) {
            return false;
        }
        if (referenceClass == null) {
            throw new IllegalArgumentException("referenceClass must not be null.");
        }
        ORDERED reference = this.getReferenceObjectByClass(referenceClass);
        return this.addAllAfter(cleanObjects, reference);
    }

    public boolean addAllFirst(Collection<? extends ORDERED> objectsToAdd) {
        ArrayList<ORDERED> cleanObjects = CollectionUtility.arrayListWithoutNullElements(objectsToAdd);
        if (cleanObjects.isEmpty()) {
            return false;
        }
        double baseOrder = 1000.0;
        if (!this.m_orderedObjects.isEmpty()) {
            this.ensureSorted();
            IOrdered first = (IOrdered)this.m_orderedObjects.getFirst();
            baseOrder = first.getOrder();
        }
        int i = 1;
        ListIterator it = cleanObjects.listIterator(cleanObjects.size());
        while (it.hasPrevious()) {
            IOrdered o = (IOrdered)it.previous();
            this.addOrdered(o, baseOrder - (double)i * 1000.0);
            ++i;
        }
        return true;
    }

    public boolean addAllLast(Collection<? extends ORDERED> objectsToAdd) {
        ArrayList<IOrdered> cleanObjects = CollectionUtility.arrayListWithoutNullElements(objectsToAdd);
        if (cleanObjects.isEmpty()) {
            return false;
        }
        double baseOrder = -1000.0;
        if (!this.m_orderedObjects.isEmpty()) {
            this.ensureSorted();
            IOrdered last = (IOrdered)this.m_orderedObjects.getLast();
            baseOrder = last.getOrder();
        }
        int i = 1;
        for (IOrdered o : cleanObjects) {
            this.addOrdered(o, baseOrder + (double)i * 1000.0);
            ++i;
        }
        return true;
    }

    public boolean addAllBefore(Collection<? extends ORDERED> objectsToAdd, ORDERED reference) {
        ArrayList<ORDERED> cleanObjects = CollectionUtility.arrayListWithoutNullElements(objectsToAdd);
        if (cleanObjects.isEmpty()) {
            return false;
        }
        if (reference == null) {
            throw new IllegalArgumentException("reference must not be null.");
        }
        if (!this.m_orderedObjects.contains(reference)) {
            throw new IllegalArgumentException("reference object is not part of this ordered collection.");
        }
        ORDERED lower = this.getAdjacentObject(reference, true);
        if (lower == null) {
            return this.addAllFirst(cleanObjects);
        }
        return this.insertAfter(cleanObjects, lower, lower.getOrder(), (reference.getOrder() - lower.getOrder()) / (double)(cleanObjects.size() + 1));
    }

    public boolean addAllAfter(Collection<? extends ORDERED> objectsToAdd, ORDERED reference) {
        ArrayList<ORDERED> cleanObjects = CollectionUtility.arrayListWithoutNullElements(objectsToAdd);
        if (cleanObjects.isEmpty()) {
            return false;
        }
        if (reference == null) {
            throw new IllegalArgumentException("reference must not be null.");
        }
        if (!this.m_orderedObjects.contains(reference)) {
            throw new IllegalArgumentException("reference object is not part of this ordered collection.");
        }
        ORDERED higher = this.getAdjacentObject(reference, false);
        if (higher == null) {
            return this.addAllLast(cleanObjects);
        }
        return this.insertAfter(cleanObjects, reference, reference.getOrder(), (higher.getOrder() - reference.getOrder()) / (double)(cleanObjects.size() + 1));
    }

    public boolean addAllAt(Collection<? extends ORDERED> objectsToAdd, int index) {
        ArrayList<ORDERED> cleanObjects = CollectionUtility.arrayListWithoutNullElements(objectsToAdd);
        if (cleanObjects.isEmpty()) {
            return false;
        }
        if (index < 0) {
            throw new IllegalArgumentException("index must not be negative.");
        }
        if (index > this.size()) {
            throw new IllegalArgumentException("index out of bounds.");
        }
        if (index == 0) {
            return this.addAllFirst(cleanObjects);
        }
        if (index == this.size()) {
            return this.addAllLast(cleanObjects);
        }
        ORDERED reference = this.getReferenceObjectAt(index);
        return this.addAllBefore(cleanObjects, reference);
    }

    private ORDERED getReferenceObjectAt(int index) {
        int i = 0;
        this.ensureSorted();
        IOrdered reference = null;
        Iterator iterator = this.m_orderedObjects.iterator();
        while (iterator.hasNext()) {
            IOrdered m_orderedObject;
            reference = m_orderedObject = (IOrdered)iterator.next();
            if (i == index) {
                return (ORDERED)reference;
            }
            ++i;
        }
        return (ORDERED)reference;
    }

    private ORDERED getReferenceObjectByClass(Class<? extends ORDERED> referenceClass) {
        this.ensureSorted();
        IOrdered reference = null;
        for (IOrdered m_orderedObject : this.m_orderedObjects) {
            reference = m_orderedObject;
            if (!referenceClass.isInstance(reference)) continue;
            return (ORDERED)reference;
        }
        throw new IllegalArgumentException("there is no reference object in this ordered collection that extends the given reference class.");
    }

    private ORDERED getAdjacentObject(ORDERED reference, boolean previous) {
        this.ensureSorted();
        ListIterator it = this.m_orderedObjects.listIterator();
        while (it.hasNext()) {
            IOrdered next = (IOrdered)it.next();
            if (next != reference) continue;
            if (previous) {
                it.previous();
                if (it.hasPrevious()) {
                    return (ORDERED)((IOrdered)it.previous());
                }
            } else if (it.hasNext()) {
                return (ORDERED)((IOrdered)it.next());
            }
            return null;
        }
        throw new IllegalArgumentException("the given reference element is not part of this ordered collection. reference: '" + reference + "'");
    }

    private boolean insertAfter(Collection<? extends ORDERED> objectsToAdd, ORDERED reference, double baseOrder, double delta) {
        ListIterator<IOrdered> it = this.m_orderedObjects.listIterator();
        while (it.hasNext()) {
            if (it.next() != reference) continue;
            int i = 1;
            for (IOrdered o : objectsToAdd) {
                o.setOrder(baseOrder + (double)i * delta);
                it.add(o);
                ++i;
            }
            return true;
        }
        return false;
    }
}

