/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UriUtility {
    private static final Logger LOG = LoggerFactory.getLogger(UriUtility.class);
    private static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();

    private UriUtility() {
    }

    public static Map<String, String> getQueryParameters(URL url) {
        return UriUtility.getQueryParameters(url, null);
    }

    public static Map<String, String> getQueryParameters(URL url, String encoding) {
        if (url == null) {
            return new HashMap<String, String>(0);
        }
        return UriUtility.getQueryParameters(UriUtility.urlToUri(url), encoding);
    }

    public static Map<String, String> getQueryParameters(URI uri) {
        return UriUtility.getQueryParameters(uri, null);
    }

    public static Map<String, String> getQueryParameters(URI uri, String encoding) {
        if (uri == null || uri.getQuery() == null) {
            return new HashMap<String, String>(0);
        }
        String[] params = UriUtility.getQueryString(uri).split("&");
        HashMap<String, String> result = new HashMap<String, String>(params.length);
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (!StringUtility.isNullOrEmpty(param)) {
                String value;
                String[] parts = StringUtility.split(param, "=");
                if (parts.length > 2) {
                    throw new ProcessingException("invalid query parameter: '" + param + "'", new Object[0]);
                }
                String key = UriUtility.decode(parts[0], encoding);
                String existingMapping = result.put(key, value = parts.length < 2 ? "" : UriUtility.decode(parts[1], encoding));
                if (existingMapping != null) {
                    LOG.warn("parameter key is used multiple times [key='{}', oldValue='{}', newValue='{}'", new Object[]{key, existingMapping, value});
                }
            }
            ++n2;
        }
        return result;
    }

    private static String getQueryString(URI uri) {
        String uriString = Assertions.assertNotNull(uri).toString();
        int start = uriString.indexOf(63);
        if (start > 0) {
            int fragmentStart = uriString.indexOf(35, start);
            int end = fragmentStart > 0 ? fragmentStart : uriString.length();
            return uriString.substring(start + 1, end);
        }
        return "";
    }

    public static String[] getPath(URI uri) {
        if (uri == null || uri.getPath() == null) {
            return new String[0];
        }
        String path = uri.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return StringUtility.split(path, "/");
    }

    public static URI urlToUri(URL url) {
        if (url == null) {
            return null;
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new ProcessingException("Exception while converting URL to URI", new Object[]{e});
        }
    }

    public static URL uriToUrl(URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new ProcessingException("Exception while converting URI to URL", new Object[]{e});
        }
    }

    public static URI toUri(String uri) {
        if (!StringUtility.hasText(uri)) {
            return null;
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new ProcessingException("Exception while parsing URI", new Object[]{e});
        }
    }

    public static URL toUrl(String url) {
        if (!StringUtility.hasText(url)) {
            return null;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ProcessingException("Exception while parsing URL", new Object[]{e});
        }
    }

    public static String decode(String uri) {
        return UriUtility.decode(uri, DEFAULT_ENCODING);
    }

    public static String decode(String uri, String encoding) {
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        try {
            return URLDecoder.decode(uri, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ProcessingException("unsupported encoding '" + encoding + "'", new Object[]{e});
        }
    }

    public static String encode(String uri) {
        return UriUtility.encode(uri, DEFAULT_ENCODING);
    }

    public static String encode(String uri, String encoding) {
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        try {
            return URLEncoder.encode(uri, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ProcessingException("unsupported encoding '" + encoding + "'", new Object[]{e});
        }
    }
}

