/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.scout.rt.platform.util.CompositeObject;
import org.eclipse.scout.rt.platform.util.StringUtility;

public final class TuningUtility {
    private static final Deque<Long> TIMER_STACK = new LinkedList<Long>();
    private static final Object ANALYSIS_MAP_LOCK = new Object();
    private static final TreeMap<String, TreeSet<CompositeObject>> ANALYSIS_MAP = new TreeMap();

    private TuningUtility() {
    }

    public static void startTimer() {
        TIMER_STACK.push(System.nanoTime());
    }

    public static long stopTimer(String name) {
        return TuningUtility.stopTimer(name, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long stopTimer(String name, boolean print, boolean addToBatch) {
        long dtNanos = !TIMER_STACK.isEmpty() ? System.nanoTime() - TIMER_STACK.pop() : -1L;
        if (print && dtNanos != -1L) {
            TuningUtility.printSingle(name, dtNanos);
        }
        if (addToBatch) {
            Object object = ANALYSIS_MAP_LOCK;
            synchronized (object) {
                TreeSet set = ANALYSIS_MAP.computeIfAbsent(name, k -> new TreeSet());
                set.add(new CompositeObject(dtNanos, set.size()));
            }
        }
        return dtNanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishAll(boolean clearTimers) {
        if (!TIMER_STACK.isEmpty()) {
            System.out.println("#TUNING: there are " + TIMER_STACK.size() + " non-finished timers (start/stop mismatch)");
        }
        while (clearTimers && !TIMER_STACK.isEmpty()) {
            TIMER_STACK.pop();
        }
        Object object = ANALYSIS_MAP_LOCK;
        synchronized (object) {
            for (Map.Entry<String, TreeSet<CompositeObject>> e : ANALYSIS_MAP.entrySet()) {
                String name = e.getKey();
                Set set = e.getValue();
                long[] seriesSorted = new long[set.size()];
                int index = 0;
                for (CompositeObject o : set) {
                    seriesSorted[index] = (Long)o.getComponent(0);
                    ++index;
                }
                TuningUtility.printMulti(name, seriesSorted);
            }
            ANALYSIS_MAP.clear();
        }
    }

    public static void finishAll() {
        TuningUtility.finishAll(false);
    }

    private static void printSingle(String label, long dtNanos) {
        int level = TIMER_STACK.size();
        StringBuilder b = new StringBuilder();
        b.append("#TUNING: ");
        int i = 0;
        while (i < level) {
            b.append("  ");
            ++i;
        }
        b.append(label);
        b.append(" took ");
        b.append(StringUtility.formatNanos(dtNanos));
        b.append("ms");
        System.out.println(b);
    }

    private static void printMulti(String name, long[] seriesSorted) {
        StringBuilder b = new StringBuilder();
        b.append("#TUNING: ");
        b.append(name);
        b.append("[").append(seriesSorted.length).append("]");
        if (seriesSorted.length > 0) {
            double sum = 0.0;
            long[] lArray = seriesSorted;
            int n = seriesSorted.length;
            int n2 = 0;
            while (n2 < n) {
                long n3 = lArray[n2];
                sum += (double)n3;
                ++n2;
            }
            b.append(" sum=").append(StringUtility.formatNanos((long)sum));
            long avg = (long)(sum / (double)seriesSorted.length);
            b.append("ms");
            b.append(" min=");
            b.append(StringUtility.formatNanos(seriesSorted[0]));
            b.append("ms");
            b.append(" avg=");
            b.append(StringUtility.formatNanos(avg));
            b.append("ms");
            b.append(" median=");
            b.append(StringUtility.formatNanos(seriesSorted[seriesSorted.length / 2]));
            b.append("ms");
            b.append(" max=");
            b.append(StringUtility.formatNanos(seriesSorted[seriesSorted.length - 1]));
            b.append("ms");
            int start = Math.max(1, seriesSorted.length / 100);
            int end = Math.min(seriesSorted.length - 2, seriesSorted.length - 1 - seriesSorted.length / 100);
            if (start < end) {
                b.append("  [without ").append(start).append(" smallest and ").append(seriesSorted.length - 1 - end).append(" largest: ");
                sum = 0.0;
                int i = start;
                while (i <= end) {
                    sum += (double)seriesSorted[i];
                    ++i;
                }
                b.append(" sum=").append(StringUtility.formatNanos((long)sum));
                avg = (long)(sum / (double)(end - start));
                b.append(" min=");
                b.append(StringUtility.formatNanos(seriesSorted[start]));
                b.append("ms");
                b.append(" avg=");
                b.append(StringUtility.formatNanos(avg));
                b.append("ms");
                b.append(" median=");
                b.append(StringUtility.formatNanos(seriesSorted[seriesSorted.length / 2]));
                b.append("ms");
                b.append(" max=");
                b.append(StringUtility.formatNanos(seriesSorted[end]));
                b.append("ms");
                b.append("]");
            }
        }
        System.out.println(b);
    }
}

