/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.platform.util.StringUtility;

public class ToStringBuilder {
    private final String m_identifier;
    private final List<Object> m_builder = new ArrayList<Object>();

    public ToStringBuilder(Object instance) {
        this(instance, true);
    }

    public ToStringBuilder(Object instance, boolean includeHashCode) {
        this.m_identifier = ToStringBuilder.createIdentifier(instance, includeHashCode);
    }

    public ToStringBuilder attr(String name, Object value) {
        this.attr(name, value, true);
        return this;
    }

    public ToStringBuilder attr(String name, Object value, boolean appendIfNull) {
        if (value != null || appendIfNull) {
            this.m_builder.add(new AbstractMap.SimpleEntry<String, Object>(name, value));
        }
        return this;
    }

    public ToStringBuilder attr(String name, String value) {
        this.attr(name, value, true);
        return this;
    }

    public ToStringBuilder attr(String name, String value, boolean appendIfNullOrEmpty) {
        if (!StringUtility.isNullOrEmpty(value) || appendIfNullOrEmpty) {
            this.m_builder.add(new AbstractMap.SimpleEntry<String, String>(name, value));
        }
        return this;
    }

    public ToStringBuilder attr(String name, boolean value) {
        this.attr(name, (Object)value);
        return this;
    }

    public ToStringBuilder attr(String name, char value) {
        this.attr(name, (Object)Character.valueOf(value));
        return this;
    }

    public ToStringBuilder attr(String name, short value) {
        this.attr(name, (Object)value);
        return this;
    }

    public ToStringBuilder attr(String name, int value) {
        this.attr(name, (Object)value);
        return this;
    }

    public ToStringBuilder attr(String name, long value) {
        this.attr(name, (Object)value);
        return this;
    }

    public ToStringBuilder attr(String name, float value) {
        this.attr(name, (Object)Float.valueOf(value));
        return this;
    }

    public ToStringBuilder attr(String name, double value) {
        this.attr(name, (Object)value);
        return this;
    }

    public ToStringBuilder attr(String name, Object ... values) {
        List<Object> collection = values == null ? Collections.emptyList() : Arrays.asList(values);
        this.attr(name, collection, true);
        return this;
    }

    public ToStringBuilder attr(String name, Collection<?> values) {
        this.attr(name, values, true);
        return this;
    }

    public ToStringBuilder attr(String name, Collection<?> values, boolean appendIfEmpty) {
        String value = StringUtility.join(",", values);
        if (StringUtility.hasText(value) || appendIfEmpty) {
            this.m_builder.add(new AbstractMap.SimpleEntry<String, String>(name, String.format("[%s]", value)));
        }
        return this;
    }

    public ToStringBuilder attr(Object value) {
        if (value != null) {
            this.m_builder.add(value);
        }
        return this;
    }

    public ToStringBuilder ref(String name, Object obj) {
        this.attr(name, ToStringBuilder.createIdentifier(obj, true));
        return this;
    }

    public String toString() {
        return String.format("%s[%s]", this.m_identifier, StringUtility.join(", ", this.m_builder));
    }

    private static String createIdentifier(Object object, boolean includeHashCode) {
        if (object == null) {
            return "null";
        }
        Class<?> clazz = ToStringBuilder.resolveClass(object);
        if (!includeHashCode) {
            return clazz.getSimpleName();
        }
        return String.format("%s@%s", clazz.getSimpleName(), Integer.toHexString(object.hashCode()));
    }

    private static Class<?> resolveClass(Object instance) {
        Class<?> clazz = instance.getClass();
        if (clazz.isAnonymousClass()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces.length > 0) {
                return interfaces[0];
            }
            return clazz.getSuperclass();
        }
        return instance.getClass();
    }
}

