/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import org.eclipse.scout.rt.platform.chain.callable.ICallableDecorator;
import org.eclipse.scout.rt.platform.util.Assertions;

public class ThreadLocalProcessor<THREAD_LOCAL>
implements ICallableDecorator {
    protected final ThreadLocal<THREAD_LOCAL> m_threadLocal;
    protected final THREAD_LOCAL m_value;

    public ThreadLocalProcessor(ThreadLocal<THREAD_LOCAL> threadLocal, THREAD_LOCAL value) {
        this.m_threadLocal = Assertions.assertNotNull(threadLocal);
        this.m_value = value;
    }

    @Override
    public ICallableDecorator.IUndecorator decorate() throws Exception {
        THREAD_LOCAL originValue = this.m_threadLocal.get();
        this.m_threadLocal.set(this.m_value);
        return () -> {
            if (originValue == null) {
                this.m_threadLocal.remove();
            } else {
                this.m_threadLocal.set(originValue);
            }
        };
    }

    public ThreadLocal<THREAD_LOCAL> getThreadLocal() {
        return this.m_threadLocal;
    }

    public THREAD_LOCAL getValue() {
        return this.m_value;
    }
}

