/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Random;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.NumberFormatProvider;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NumberUtility {
    private static final Logger LOG = LoggerFactory.getLogger(NumberUtility.class);
    private static final Random UNSECURE_RANDOM = new Random();

    private NumberUtility() {
    }

    public static Double toDouble(Number n) {
        if (n == null) {
            return null;
        }
        if (n instanceof Float) {
            return Double.valueOf(n.toString());
        }
        return n.doubleValue();
    }

    public static int divideAndCeil(int dividend, int divisor) {
        return (dividend + divisor - 1) / divisor;
    }

    public static Integer toInteger(Number n) {
        if (n == null) {
            return null;
        }
        return n.intValue();
    }

    public static Long toLong(Number n) {
        if (n == null) {
            return null;
        }
        return n.longValue();
    }

    public static BigDecimal numberToBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number == null) {
            return null;
        }
        BigDecimal retVal = null;
        try {
            retVal = new BigDecimal(number.toString());
        }
        catch (NumberFormatException e) {
            LOG.warn("converting to BigDecimal failed for Number: '{}'", (Object)number);
        }
        return retVal;
    }

    public static BigDecimal toBigDecimal(Double d) {
        if (d == null) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public static BigInteger toBigInteger(Long l) {
        if (l == null) {
            return null;
        }
        return BigInteger.valueOf(l);
    }

    public static double median(double ... a) {
        if (a == null) {
            return 0.0;
        }
        int count = a.length;
        double[] b = new double[a.length];
        System.arraycopy(a, 0, b, 0, count);
        Arrays.sort(b);
        if (count > 0) {
            return b[count / 2];
        }
        return 0.0;
    }

    public static boolean hasBit(int value, int index) {
        return NumberUtility.getBit(value, index);
    }

    public static boolean getBit(int value, int index) {
        return (value & 1 << index) != 0;
    }

    public static BigDecimal sum(Collection<? extends Number> numbers) {
        BigDecimal sum = BigDecimal.ZERO;
        if (CollectionUtility.hasElements(numbers)) {
            for (Number number : numbers) {
                if (number == null) continue;
                BigDecimal augend = NumberUtility.numberToBigDecimal(number);
                sum = sum.add(augend == null ? BigDecimal.ZERO : augend);
            }
        }
        return sum;
    }

    public static BigDecimal sum(Number ... a) {
        if (a == null) {
            return BigDecimal.ZERO;
        }
        if (a.length == 0) {
            return BigDecimal.ZERO;
        }
        return NumberUtility.sum(Arrays.asList(a));
    }

    public static double min(double ... a) {
        if (a == null) {
            return 0.0;
        }
        if (a.length == 0) {
            return 0.0;
        }
        double min = Double.MAX_VALUE;
        double[] dArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            min = Math.min(min, d);
            ++n2;
        }
        return min;
    }

    public static double max(double ... a) {
        if (a == null) {
            return 0.0;
        }
        if (a.length == 0) {
            return 0.0;
        }
        double max = Double.MIN_VALUE;
        double[] dArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            max = Math.max(max, d);
            ++n2;
        }
        return max;
    }

    public static long randomLong() {
        return UNSECURE_RANDOM.nextLong();
    }

    public static int randomInt() {
        return UNSECURE_RANDOM.nextInt();
    }

    public static int randomInt(int size) {
        return UNSECURE_RANDOM.nextInt(size);
    }

    public static double randomDouble() {
        return UNSECURE_RANDOM.nextDouble();
    }

    public static Number roundBigDecimal(Number value, double precision) {
        if (value != null) {
            BigDecimal val = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
            BigDecimal prec = BigDecimal.valueOf(precision);
            return val.divide(prec, RoundingMode.HALF_EVEN).setScale(0, RoundingMode.HALF_EVEN).multiply(prec);
        }
        return null;
    }

    public static double round(double value, double precision) {
        return (double)Math.round(value / precision) * precision;
    }

    public static int setBit(int value, int index) {
        return value | 1 << index;
    }

    public static int clearBit(int value, int index) {
        return value & (value ^ 1 << index);
    }

    public static Number sign(Number n) {
        if (n == null) {
            return 0;
        }
        double d = n.doubleValue();
        if (d < 0.0) {
            return -1;
        }
        if (d > 0.0) {
            return 1;
        }
        return 0;
    }

    public static int parseInt(String s) {
        if (StringUtility.isNullOrEmpty(s)) {
            return 0;
        }
        Integer intValue = TypeCastUtility.castValue(s, Integer.class);
        return intValue;
    }

    public static long parseLong(String s) {
        if (StringUtility.isNullOrEmpty(s)) {
            return 0L;
        }
        Long longValue = TypeCastUtility.castValue(s, Long.class);
        return longValue;
    }

    public static double parseDouble(String s) {
        if (StringUtility.isNullOrEmpty(s)) {
            return 0.0;
        }
        Double doubleValue = TypeCastUtility.castValue(s, Double.class);
        return doubleValue;
    }

    public static String format(Number n) {
        if (n == null) {
            return "";
        }
        Locale loc = NlsLocale.get();
        return BEANS.get(NumberFormatProvider.class).getNumberInstance(loc).format(n);
    }

    public static boolean isDoubleDifferent(double d1, double d2, double epsilon) {
        if (Double.compare(d1, d2) == 0) {
            return false;
        }
        return !(Math.abs(d1 - d2) <= Math.abs(epsilon));
    }

    public static int nvl(Integer value, int valueWhenNull) {
        if (value != null) {
            return value;
        }
        return valueWhenNull;
    }

    public static long nvl(Long value, long valueWhenNull) {
        if (value != null) {
            return value;
        }
        return valueWhenNull;
    }

    public static float nvl(Float value, float valueWhenNull) {
        if (value != null) {
            return value.floatValue();
        }
        return valueWhenNull;
    }

    public static double nvl(Double value, double valueWhenNull) {
        if (value != null) {
            return value;
        }
        return valueWhenNull;
    }

    public static double trunc(Number n) {
        if (n == null) {
            return 0.0;
        }
        return Math.floor(n.doubleValue());
    }

    public static int longToInt(Long l) {
        if (l != null) {
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (l < Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return l.intValue();
        }
        return 0;
    }

    public static BigDecimal getBigDecimalValue(Object o) {
        if (o != null && !o.toString().isEmpty()) {
            return new BigDecimal(o.toString());
        }
        return null;
    }

    public static boolean isValidDouble(String str, String decimalSeparator, String thousandsSeparator) {
        if (str == null || str.isEmpty()) {
            return true;
        }
        if (thousandsSeparator != null && !thousandsSeparator.isEmpty()) {
            str = str.replace(thousandsSeparator, "");
        }
        String regex = "[+-]?\\d*";
        if (decimalSeparator != null && !decimalSeparator.isEmpty()) {
            regex = String.valueOf(regex) + "(\\" + decimalSeparator + "\\d+)?";
        }
        return str.matches(regex);
    }
}

