/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.scout.rt.platform.exception.ProcessingException;

public final class HexUtility {
    private static final char[] BYTE_TO_CHAR_LOWER = "0123456789abcdef".toCharArray();
    private static final char[] BYTE_TO_CHAR_UPPER = "0123456789ABCDEF".toCharArray();
    private static final int[] CHAR_TO_BYTE;

    static {
        int[] charToByte = new int[256];
        int i = 0;
        while (i < charToByte.length) {
            charToByte[i] = -1;
            ++i;
        }
        i = 0;
        while (i < BYTE_TO_CHAR_LOWER.length) {
            charToByte[HexUtility.BYTE_TO_CHAR_LOWER[i]] = i;
            ++i;
        }
        i = 0;
        while (i < BYTE_TO_CHAR_UPPER.length) {
            charToByte[HexUtility.BYTE_TO_CHAR_UPPER[i]] = i;
            ++i;
        }
        CHAR_TO_BYTE = charToByte;
    }

    private HexUtility() {
    }

    public static String encode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int length = bytes.length;
        if (length == 0) {
            return "";
        }
        StringWriter out = new StringWriter(length * 2);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (HexOutputStream h = new HexOutputStream(out);){
                h.write(bytes);
                h.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ProcessingException("Unexpected behaviour", new Object[]{e});
        }
        return out.toString();
    }

    public static byte[] decode(String hex) {
        if (hex == null) {
            return null;
        }
        int length = hex.length();
        if (length == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(length / 2);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (HexInputStream h = new HexInputStream(new StringReader(hex));){
                int b;
                while ((b = h.read()) >= 0) {
                    out.write(b);
                }
                out.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ProcessingException("Unexpected behaviour", new Object[]{e});
        }
        return out.toByteArray();
    }

    public static class HexInputStream
    extends InputStream {
        private final InputStream m_in0;
        private final Reader m_in1;

        public HexInputStream(Reader in) {
            this.m_in0 = null;
            this.m_in1 = in;
        }

        public HexInputStream(InputStream in) {
            this.m_in0 = in;
            this.m_in1 = null;
        }

        @Override
        public int read() throws IOException {
            int hi = this.readNext4Bits();
            if (hi < 0) {
                return -1;
            }
            int lo = this.readNext4Bits();
            if (lo < 0) {
                return -1;
            }
            return hi << 4 | lo;
        }

        protected int readNext4Bits() throws IOException {
            int ch;
            do {
                int n = ch = this.m_in0 != null ? this.m_in0.read() : this.m_in1.read();
                if (ch >= 0) continue;
                return -1;
            } while ((ch = CHAR_TO_BYTE[ch]) < 0);
            return ch;
        }

        @Override
        public void close() throws IOException {
            if (this.m_in0 != null) {
                this.m_in0.close();
            }
            if (this.m_in1 != null) {
                this.m_in1.close();
            }
        }
    }

    public static class HexOutputStream
    extends OutputStream {
        private final OutputStream m_out0;
        private final Writer m_out1;

        public HexOutputStream(OutputStream out) {
            this.m_out0 = out;
            this.m_out1 = null;
        }

        public HexOutputStream(Writer out) {
            this.m_out0 = null;
            this.m_out1 = out;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.m_out0 != null) {
                this.m_out0.write(BYTE_TO_CHAR_LOWER[b >> 4 & 0xF]);
                this.m_out0.write(BYTE_TO_CHAR_LOWER[b & 0xF]);
            } else {
                this.m_out1.write(BYTE_TO_CHAR_LOWER[b >> 4 & 0xF]);
                this.m_out1.write(BYTE_TO_CHAR_LOWER[b & 0xF]);
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.m_out0 != null) {
                this.m_out0.flush();
            } else {
                this.m_out1.flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.m_out0 != null) {
                this.m_out0.close();
            } else {
                this.m_out1.close();
            }
        }
    }
}

