/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.resource.MimeType;
import org.eclipse.scout.rt.platform.util.IMimeTypeDetector;
import org.eclipse.scout.rt.platform.util.IOUtility;

public final class FileUtility {
    private static final int KILO_BYTE = 1024;
    private static final Pattern PAT_FILENAME_REMOVE_INVALID_CHARACTERS = Pattern.compile("[<>:\"/\\\\|?*\\x00-\\x1F]");
    private static final Pattern PAT_FILENAME_REMOVE_LEADING_CHARACTERS = Pattern.compile("^[\\s.]+([^\\s.].*)$");
    private static final Pattern PAT_FILENAME_REMOVE_TRAILING_CHARACTERS = Pattern.compile("^(.*[^\\s.])[\\s.]+$");
    private static final Pattern PAT_FILENAME_TRIM = Pattern.compile("^[\\s.]*$");
    private static final String DEFAULT_FILENAME = "_";

    private FileUtility() {
    }

    public static void extractArchive(File archiveFile, File targetDir) throws IOException {
        File destinationDir = targetDir.getCanonicalFile();
        Path destinationPath = destinationDir.toPath();
        destinationDir.mkdirs();
        destinationDir.setLastModified(archiveFile.lastModified());
        String localFile = destinationDir.getName();
        Throwable throwable = null;
        Object var6_7 = null;
        try (JarFile jar = new JarFile(archiveFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry file = entries.nextElement();
                String name = file.getName();
                if (name.startsWith(localFile)) {
                    name = name.substring(localFile.length());
                }
                while (name.startsWith("/") || name.startsWith("\\")) {
                    name = name.substring(1);
                }
                File f = new File(destinationDir, name).getCanonicalFile();
                if (!f.toPath().startsWith(destinationPath)) {
                    throw new IllegalArgumentException("Entry is outside of the target dir: " + name);
                }
                if (file.isDirectory()) {
                    f.mkdirs();
                    if (file.getTime() < 0L) continue;
                    f.setLastModified(file.getTime());
                    continue;
                }
                f.getParentFile().mkdirs();
                InputStream is = null;
                FileOutputStream fos = null;
                try {
                    int len;
                    is = jar.getInputStream(file);
                    fos = new FileOutputStream(f);
                    byte[] buf = new byte[102400];
                    while ((len = is.read(buf)) > 0) {
                        fos.write(buf, 0, len);
                    }
                }
                finally {
                    if (fos != null) {
                        fos.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                if (file.getTime() < 0L) continue;
                f.setLastModified(file.getTime());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(File source, File dest) throws IOException {
        if (!source.exists()) {
            throw new FileNotFoundException(source.getAbsolutePath());
        }
        if (!source.canRead()) {
            throw new IOException("cannot read " + source);
        }
        if (dest.exists() && !dest.canWrite()) {
            throw new IOException("cannot write " + dest);
        }
        if (source.isDirectory()) {
            throw new IOException("source is a directory: " + source);
        }
        if (dest.isDirectory()) {
            String sourceFileName = source.getName();
            FileUtility.copyFile(source, new File(dest, sourceFileName));
        }
        boolean needCopy = true;
        if (dest.exists()) {
            needCopy = dest.length() != source.length() || dest.lastModified() != source.lastModified();
        }
        if (!needCopy) return;
        int mbCount = 64;
        boolean done = false;
        while (true) {
            if (done) {
                if (!dest.exists()) return;
                if (!source.exists()) return;
                dest.setLastModified(source.lastModified());
                return;
            }
            if (!dest.exists()) {
                dest.getParentFile().mkdirs();
            }
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try {
                    FileInputStream in = new FileInputStream(source);
                    try {
                        block37: {
                            FileChannel input = in.getChannel();
                            try {
                                block36: {
                                    FileOutputStream out = new FileOutputStream(dest);
                                    try {
                                        try (FileChannel output = out.getChannel();){
                                            int maxCount = mbCount * 1024 * 1024 - 32768;
                                            long size = input.size();
                                            long position = 0L;
                                            while (true) {
                                                if (position >= size) {
                                                    done = true;
                                                    break;
                                                }
                                                position += input.transferTo(position, maxCount, output);
                                            }
                                        }
                                        if (out == null) break block36;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        if (out == null) throw throwable;
                                        out.close();
                                        throw throwable;
                                    }
                                    out.close();
                                }
                                if (input == null) break block37;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (input == null) throw throwable;
                                input.close();
                                throw throwable;
                            }
                            input.close();
                        }
                        if (in == null) continue;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        if (in == null) throw throwable;
                        in.close();
                        throw throwable;
                    }
                    in.close();
                    continue;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                        throw throwable;
                    }
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                    throw throwable;
                }
            }
            catch (IOException ioXcp) {
                if (!ioXcp.getMessage().contains("Insufficient system resources exist to complete the requested service")) throw ioXcp;
                if (--mbCount != 0) continue;
                done = true;
                continue;
            }
            break;
        }
    }

    private static byte[] readFile(File source) throws IOException {
        if (!source.exists()) {
            throw new FileNotFoundException(source.getAbsolutePath());
        }
        if (!source.canRead()) {
            throw new IOException("cannot read " + source);
        }
        if (source.isDirectory()) {
            throw new IOException("source is a directory: " + source);
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream input = new FileInputStream(source);){
            byte[] data = new byte[(int)source.length()];
            int n = 0;
            while (n < data.length) {
                n += input.read(data, n, data.length - n);
            }
            return data;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void copyTree(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            String[] children;
            if (!targetLocation.exists()) {
                targetLocation.mkdirs();
                targetLocation.setLastModified(sourceLocation.lastModified());
            }
            if ((children = sourceLocation.list()) != null && children.length > 0) {
                String[] stringArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    String aChildren = stringArray[n2];
                    FileUtility.copyTree(new File(sourceLocation, aChildren), new File(targetLocation, aChildren));
                    ++n2;
                }
            }
        } else {
            FileUtility.copyFile(sourceLocation, targetLocation);
        }
    }

    public static List<File> listTree(File f, boolean includeFiles, boolean includeFolders) {
        ArrayList<File> list = new ArrayList<File>();
        FileUtility.listTreeRec(f, list, includeFiles, includeFolders);
        return list;
    }

    private static void listTreeRec(File f, List<File> list, boolean includeFiles, boolean includeFolders) {
        if (f.isDirectory()) {
            String[] children;
            if (includeFolders) {
                list.add(f);
            }
            if ((children = f.list()) != null && children.length > 0) {
                String[] stringArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    String aChildren = stringArray[n2];
                    FileUtility.listTreeRec(new File(f, aChildren), list, includeFiles, includeFolders);
                    ++n2;
                }
            }
        } else if (includeFiles) {
            list.add(f);
        }
    }

    public static void compressArchive(File srcDir, File archiveFile) throws IOException {
        archiveFile.delete();
        Throwable throwable = null;
        Object var3_4 = null;
        try (JarOutputStream zOut = new JarOutputStream(new FileOutputStream(archiveFile));){
            FileUtility.addFolderToJar(srcDir, srcDir, zOut);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void addFolderToJar(File baseDir, File srcdir, JarOutputStream zOut) throws IOException {
        if (!srcdir.exists() || !srcdir.isDirectory()) {
            throw new IOException("source directory " + srcdir + " does not exist or is not a folder");
        }
        File[] files = srcdir.listFiles();
        if (files == null || files.length < 1) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.exists() && !f.isHidden()) {
                if (f.isDirectory()) {
                    FileUtility.addFolderToJar(baseDir, f, zOut);
                } else {
                    FileUtility.addFileToJar(baseDir, f, zOut);
                }
            }
            ++n2;
        }
    }

    private static void addFileToJar(File baseDir, File src, JarOutputStream zOut) throws IOException {
        String name = src.getAbsolutePath();
        String prefix = baseDir.getAbsolutePath();
        if (prefix.endsWith("/") || prefix.endsWith("\\")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        name = name.substring(prefix.length() + 1);
        name = name.replace('\\', '/');
        long timestamp = src.lastModified();
        byte[] data = FileUtility.readFile(src);
        FileUtility.addFileToJar(name, data, timestamp, zOut);
    }

    private static void addFileToJar(String name, byte[] data, long timestamp, JarOutputStream zOut) throws IOException {
        ZipEntry entry = new ZipEntry(name);
        entry.setTime(timestamp);
        zOut.putNextEntry(entry);
        zOut.write(data);
        zOut.closeEntry();
    }

    public static String getContentTypeForExtension(String ext) {
        if (ext == null) {
            return FileUtility.getMimeType(null);
        }
        if (!ext.isEmpty() && ext.charAt(0) == '.') {
            ext = ext.substring(1);
        }
        ext = ext.toLowerCase(Locale.US).trim();
        return FileUtility.getMimeType("file." + ext);
    }

    public static String getContentType(File f) {
        if (f == null || !f.exists()) {
            return FileUtility.getMimeType(null);
        }
        return FileUtility.getMimeType(Paths.get(f.toURI()));
    }

    public static String getMimeType(String path) {
        try {
            return FileUtility.getMimeType(Paths.get(path, new String[0]));
        }
        catch (RuntimeException e1) {
            try {
                return FileUtility.getMimeType(Paths.get("file." + FileUtility.getFileExtension(path), new String[0]));
            }
            catch (RuntimeException e2) {
                return FileUtility.getMimeType(null);
            }
        }
    }

    public static String getMimeType(Path path) {
        if (path == null) {
            return MimeType.APPLICATION_OCTET_STREAM.getType();
        }
        for (IMimeTypeDetector d : BEANS.all(IMimeTypeDetector.class)) {
            String m = d.getMimeType(path);
            if (m == null) continue;
            return m;
        }
        return MimeType.APPLICATION_OCTET_STREAM.getType();
    }

    public static boolean isZipFile(File file) {
        if (file == null || file.isDirectory() || !file.canRead() || file.length() < 4L) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));){
                int test = in.readInt();
                boolean bl = test == 1347093252;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static byte[] removeByteOrderMark(File f) {
        return IOUtility.removeByteOrderMark(IOUtility.getContent(f.getAbsolutePath()));
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtility.getFileExtension(file.getName());
    }

    public static String getFileExtension(String fileName) {
        String[] parts = FileUtility.getFilenameParts(fileName);
        if (parts == null) {
            return null;
        }
        return parts[1];
    }

    public static String[] getFilenameParts(File file) {
        if (file == null) {
            return null;
        }
        return FileUtility.getFilenameParts(file.getName());
    }

    public static String[] getFilenameParts(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            String[] stringArray = new String[2];
            stringArray[0] = fileName;
            return stringArray;
        }
        return new String[]{fileName.substring(0, index), fileName.substring(index + 1)};
    }

    /*
     * Unable to fully structure code
     */
    public static String toValidFilename(String filename) {
        block9: {
            if (filename == null) {
                return "_";
            }
            s = filename;
            s = FileUtility.PAT_FILENAME_REMOVE_INVALID_CHARACTERS.matcher(s).replaceAll("");
            try {
                Paths.get(s, new String[0]);
                break block9;
            }
            catch (InvalidPathException ex) {
                buf = new StringBuilder();
                var7_5 = s.toCharArray();
                var6_6 = var7_5.length;
                var5_7 = 0;
                ** while (var5_7 < var6_6)
            }
lbl-1000:
            // 1 sources

            {
                ch = var7_5[var5_7];
                try {
                    Paths.get("a" + ch + "a", new String[0]);
                    buf.append(ch);
                }
                catch (InvalidPathException var8_9) {
                    // empty catch block
                }
                ++var5_7;
                continue;
            }
lbl26:
            // 1 sources

            s = buf.toString();
        }
        s = FileUtility.PAT_FILENAME_REMOVE_LEADING_CHARACTERS.matcher(s).replaceAll("$1");
        s = FileUtility.PAT_FILENAME_REMOVE_TRAILING_CHARACTERS.matcher(s).replaceAll("$1");
        s = FileUtility.PAT_FILENAME_TRIM.matcher(s).replaceAll("");
        if (s.isEmpty()) {
            return "_";
        }
        if (s.length() > 250) {
            dot = s.lastIndexOf(46);
            v0 = suffix = dot > 0 ? s.substring(dot) : "";
            if (suffix.length() > 32) {
                suffix = "";
            }
            s = String.valueOf(s.substring(0, 250 - suffix.length())) + suffix;
        }
        return s;
    }

    public static boolean isValidFilename(String filename) {
        return FileUtility.toValidFilename(filename).equals(filename);
    }
}

