/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;

public class BomInputStreamReader
extends InputStreamReader {
    public static final char BOM_CHAR = '\ufeff';
    private static final Set<String> SUPPORTED_UNICODE_CHARSETS;
    private static final int EOF = -1;
    boolean m_firstChar = true;

    static {
        Charset[] cs = new Charset[]{StandardCharsets.UTF_8, StandardCharsets.UTF_16, StandardCharsets.UTF_16BE, StandardCharsets.UTF_16LE};
        HashSet<String> supportedCharsets = new HashSet<String>();
        Charset[] charsetArray = cs;
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            Charset charset = charsetArray[n2];
            supportedCharsets.add(charset.name());
            supportedCharsets.addAll(charset.aliases());
            ++n2;
        }
        SUPPORTED_UNICODE_CHARSETS = supportedCharsets;
    }

    public BomInputStreamReader(InputStream in, String charsetName) throws UnsupportedEncodingException {
        super(in, charsetName);
    }

    public BomInputStreamReader(InputStream in, Charset cs) {
        super(in, cs);
    }

    public BomInputStreamReader(InputStream in, CharsetDecoder dec) {
        super(in, dec);
    }

    @Override
    public int read() throws IOException {
        int ch = super.read();
        if (this.m_firstChar) {
            this.m_firstChar = false;
            if (ch == 65279 && SUPPORTED_UNICODE_CHARSETS.contains(this.getEncoding())) {
                ch = super.read();
            }
        }
        return ch;
    }

    @Override
    public int read(char[] cbuf, int offset, int length) throws IOException {
        if (length == 0) {
            return super.read(cbuf, offset, length);
        }
        if (this.m_firstChar) {
            this.m_firstChar = false;
            if (SUPPORTED_UNICODE_CHARSETS.contains(this.getEncoding())) {
                int ch = super.read();
                if (ch == -1) {
                    return -1;
                }
                if (ch != 65279) {
                    cbuf[offset] = (char)ch;
                    return super.read(cbuf, offset + 1, length - 1) + 1;
                }
            }
        }
        return super.read(cbuf, offset, length);
    }
}

