/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.transaction;

import org.eclipse.scout.rt.platform.transaction.ITransaction;
import org.eclipse.scout.rt.platform.transaction.ITransactionCommitProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoPhaseTransactionCommitProtocol
implements ITransactionCommitProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(TwoPhaseTransactionCommitProtocol.class);

    /*
     * Loose catch block
     */
    @Override
    public void commitOrRollback(ITransaction tx) {
        block10: {
            if (tx.hasFailures()) {
                this.rollback(tx);
                return;
            }
            if (!this.commitPhase1(tx)) {
                this.rollback(tx);
                return;
            }
            this.commitPhase2(tx);
            break block10;
            catch (Error | RuntimeException e) {
                LOG.error("Unexpected error during commit of XA transaction [2PC-phase='commit', tx={}]", (Object)tx, (Object)e);
                tx.addFailure(e);
                this.rollback(tx);
                throw e;
            }
            finally {
                this.release(tx);
            }
        }
    }

    protected boolean commitPhase1(ITransaction tx) {
        return tx.commitPhase1();
    }

    protected void commitPhase2(ITransaction tx) {
        tx.commitPhase2();
    }

    protected void rollback(ITransaction tx) {
        tx.rollback();
    }

    protected void release(ITransaction tx) {
        tx.release();
    }
}

