/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.text;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.text.ITextProviderService;

@ApplicationScoped
public class ScoutTexts {
    private volatile List<? extends ITextProviderService> m_textProviders;

    public ScoutTexts() {
        this.reloadTextProviders();
    }

    public void reloadTextProviders() {
        this.m_textProviders = BEANS.all(ITextProviderService.class);
    }

    public final String getText(String key, String ... messageArguments) {
        return this.getText((Locale)null, key, messageArguments);
    }

    public final String getText(Locale locale, String key, String ... messageArguments) {
        return this.getTextInternal(locale, key, this.getDefaultFallback(key), messageArguments);
    }

    public Map<String, String> getTextMap(Locale locale) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<? extends ITextProviderService> providers = this.getTextProviders();
        int i = providers.size() - 1;
        while (i >= 0) {
            map.putAll(providers.get(i).getTextMap(locale));
            --i;
        }
        return map;
    }

    protected List<? extends ITextProviderService> getTextProviders() {
        return this.m_textProviders;
    }

    protected String getTextInternal(Locale locale, String key, String fallback, String ... messageArguments) {
        for (ITextProviderService iTextProviderService : this.getTextProviders()) {
            String result = iTextProviderService.getText(locale, key, messageArguments);
            if (result == null) continue;
            return result;
        }
        return fallback;
    }

    protected String getDefaultFallback(String key) {
        return "{undefined text " + key + "}";
    }

    public String getTextWithFallback(Locale locale, String key, String fallback, String ... messageArguments) {
        return this.getTextInternal(locale, key, fallback, messageArguments);
    }
}

