/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.status;

import java.io.Serializable;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.util.StringUtility;

@Order(value=9.876543212345678E16)
public class Status
implements IStatus,
Serializable {
    private static final long serialVersionUID = 382223180907716448L;
    public static final Status OK_STATUS = new Status(1);
    private int m_severity;
    private final String m_message;
    private int m_code;
    private String m_iconId;
    private final double m_order;

    public Status(int severity) {
        this(null, severity);
    }

    public Status(String message) {
        this(message, 0x1000000);
    }

    public Status(String message, int severity) {
        this(message, severity, 0);
    }

    public Status(String message, int severity, int code) {
        this.m_severity = severity;
        this.m_message = message;
        this.m_code = code;
        Class<?> clazz = this.getClass();
        while (clazz.getAnnotation(Order.class) == null) {
            clazz = clazz.getSuperclass();
        }
        this.m_order = clazz.getAnnotation(Order.class).value();
    }

    public Status() {
        this("undefined");
    }

    @Override
    public int getSeverity() {
        return this.m_severity;
    }

    public void setSeverity(int severity) {
        this.withSeverity(severity);
    }

    public Status withSeverity(int severity) {
        this.m_severity = severity;
        return this;
    }

    @Override
    public boolean matches(int severityMask) {
        return (this.m_severity & severityMask) != 0;
    }

    @Override
    public String getMessage() {
        return StringUtility.emptyIfNull(this.m_message);
    }

    @Override
    public String getIconId() {
        return this.m_iconId;
    }

    public Status withIconId(String iconId) {
        this.m_iconId = iconId;
        return this;
    }

    @Override
    public int getCode() {
        return this.m_code;
    }

    public void setCode(int code) {
        this.m_code = code;
    }

    public Status withCode(int code) {
        this.m_code = code;
        return this;
    }

    @Override
    public boolean isOK() {
        return this.getSeverity() == 1;
    }

    @Override
    public double getOrder() {
        return this.m_order;
    }

    @Override
    public boolean isMultiStatus() {
        return false;
    }

    @Override
    public int compareTo(IStatus o) {
        if (o.getSeverity() - this.getSeverity() != 0) {
            return o.getSeverity() - this.getSeverity();
        }
        if (o.getOrder() - this.getOrder() != 0.0) {
            return (int)(this.getOrder() - o.getOrder());
        }
        if (this.getMessage() != null && o.getMessage() != null) {
            return this.getMessage().compareTo(o.getMessage());
        }
        if (this.getMessage() != null) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + "severity=" + this.getSeverityName() + ", message=" + this.m_message + "]";
    }

    protected String getSeverityName() {
        return Status.getSeverityName(this.getSeverity());
    }

    public static String getSeverityName(int severity) {
        switch (severity) {
            case 1: {
                return "OK";
            }
            case 256: {
                return "INFO";
            }
            case 65536: {
                return "WARNING";
            }
            case 0x1000000: {
                return "ERROR";
            }
        }
        return "undefined";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_code;
        result = 31 * result + (this.m_iconId == null ? 0 : this.m_iconId.hashCode());
        result = 31 * result + (this.m_message == null ? 0 : this.m_message.hashCode());
        long temp = Double.doubleToLongBits(this.m_order);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.m_severity;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Status other = (Status)obj;
        if (this.m_code != other.m_code) {
            return false;
        }
        if (this.m_iconId == null ? other.m_iconId != null : !this.m_iconId.equals(other.m_iconId)) {
            return false;
        }
        if (this.m_message == null ? other.m_message != null : !this.m_message.equals(other.m_message)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m_order) != Double.doubleToLongBits(other.m_order)) {
            return false;
        }
        return this.m_severity == other.m_severity;
    }
}

