/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.scout.rt.platform.status.IMultiStatus;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.status.Status;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;

public class MultiStatus
extends Status
implements IMultiStatus {
    private static final long serialVersionUID = -4166865994075130263L;
    private final SortedSet<IStatus> m_children = new TreeSet<IStatus>();

    public MultiStatus() {
        super(null);
    }

    public MultiStatus(IMultiStatus ms) {
        this();
        Assertions.assertNotNull(ms);
        for (IStatus s : ms.getChildren()) {
            this.add(s);
        }
    }

    @Override
    public int getSeverity() {
        if (!this.m_children.isEmpty()) {
            return this.m_children.first().getSeverity();
        }
        return 1;
    }

    @Override
    public double getOrder() {
        if (!this.m_children.isEmpty()) {
            return this.m_children.first().getOrder();
        }
        return 9.876543212345678E16;
    }

    @Override
    public String getMessage() {
        return this.formatMessages(this.filterSameOrder(this.filterSameSeverity(this.m_children)));
    }

    @Override
    public int getCode() {
        if (!this.m_children.isEmpty()) {
            return this.m_children.first().getCode();
        }
        return super.getCode();
    }

    private List<IStatus> filterSameOrder(Collection<IStatus> statuses) {
        ArrayList<IStatus> res = new ArrayList<IStatus>();
        for (IStatus s : statuses) {
            if (s.getOrder() != this.getOrder()) break;
            res.add(s);
        }
        return res;
    }

    private List<IStatus> filterSameSeverity(Collection<IStatus> statuses) {
        ArrayList<IStatus> res = new ArrayList<IStatus>();
        for (IStatus s : statuses) {
            if (s.getSeverity() != this.getSeverity()) break;
            res.add(s);
        }
        return res;
    }

    protected String formatMessages(List<IStatus> statuses) {
        ArrayList<String> messages = new ArrayList<String>();
        for (IStatus s : statuses) {
            messages.add(s.getMessage());
        }
        return StringUtility.join("\n", messages);
    }

    public void add(IStatus status) {
        this.m_children.add(Assertions.assertNotNull(status));
    }

    public void addAll(List<IStatus> status) {
        this.m_children.addAll((Collection<IStatus>)Assertions.assertNotNull(status));
    }

    public void remove(IStatus status) {
        this.m_children.remove(Assertions.assertNotNull(status));
    }

    @Override
    public void removeAll(IStatus status) {
        for (IStatus child : this.getChildren()) {
            if (Assertions.assertNotNull(status).equals(child)) {
                this.m_children.remove(Assertions.assertNotNull(child));
                continue;
            }
            if (!(child instanceof IMultiStatus)) continue;
            ((IMultiStatus)child).removeAll(status);
        }
    }

    @Override
    public void removeAll(Class<? extends IStatus> clazz) {
        for (IStatus child : this.getChildren()) {
            if (!Assertions.assertNotNull(clazz).isAssignableFrom(child.getClass())) continue;
            this.m_children.remove(Assertions.assertNotNull(child));
        }
    }

    @Override
    public boolean isMultiStatus() {
        return true;
    }

    @Override
    public List<IStatus> getChildren() {
        return CollectionUtility.arrayList(this.m_children);
    }

    @Override
    public boolean containsStatus(IStatus status) {
        Assertions.assertNotNull(status);
        for (IStatus child : this.getChildren()) {
            if (!status.equals(child) && (!(child instanceof IMultiStatus) || !((IMultiStatus)child).containsStatus(status))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsStatus(Class<? extends IStatus> clazz) {
        Assertions.assertNotNull(clazz);
        for (IStatus child : this.getChildren()) {
            if (!clazz.isAssignableFrom(child.getClass()) && (!(child instanceof IMultiStatus) || !((IMultiStatus)child).containsStatus(clazz))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "MultiStatus [severity=" + this.getSeverity() + ", message=" + this.getMessage() + ", children=" + this.m_children + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m_children == null ? 0 : this.m_children.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiStatus other = (MultiStatus)obj;
        return !(this.m_children == null ? other.m_children != null : !CollectionUtility.equalsCollection(this.m_children, other.m_children));
    }
}

