/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.security.EncryptionKey;
import org.eclipse.scout.rt.platform.security.ISecurityProvider;
import org.eclipse.scout.rt.platform.security.KeyPairBytes;
import org.eclipse.scout.rt.platform.util.Assertions;

@Order(value=5500.0)
public class SunSecurityProvider
implements ISecurityProvider {
    protected static final int MIN_PASSWORD_HASH_ITERATIONS = 10000;
    protected static final int BUF_SIZE = 8192;
    protected static final int GCM_INITIALIZATION_VECTOR_LEN = 16;
    protected static final int GCM_AUTH_TAG_BIT_LEN = 128;

    @Override
    public EncryptionKey createEncryptionKey(char[] password, byte[] salt, int keyLen) {
        Assertions.assertGreater(Assertions.assertNotNull(password, "password must not be null.", new Object[0]).length, 0, "empty password is not allowed.", new Object[0]);
        Assertions.assertGreater(Assertions.assertNotNull(salt, "salt must be provided.", new Object[0]).length, 0, "empty salt is not allowed.", new Object[0]);
        Assertions.assertTrue(keyLen == 128 || keyLen == 192 || keyLen == 256, "key length must be 128, 192 or 256.", new Object[0]);
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(this.getSecretKeyAlgorithm(), this.getCipherAlgorithmProvider());
            PBEKeySpec spec = new PBEKeySpec(password, salt, this.getKeyDerivationIterationCount(), keyLen + 128);
            SecretKey tmpSecret = factory.generateSecret(spec);
            byte[] encoded = tmpSecret.getEncoded();
            byte[] iv = new byte[16];
            byte[] key = new byte[keyLen / 8];
            System.arraycopy(encoded, 0, key, 0, key.length);
            System.arraycopy(encoded, key.length, iv, 0, 16);
            SecretKeySpec secretKey = new SecretKeySpec(key, this.getCipherAlgorithm());
            GCMParameterSpec parameters = new GCMParameterSpec(128, iv);
            return new EncryptionKey(secretKey, parameters);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProcessingException("Unable to create secret. Algorithm could not be found. Make sure to use JRE 1.8 or newer.", new Object[]{e});
        }
        catch (NoSuchProviderException | InvalidKeySpecException e) {
            throw new ProcessingException("Unable to create secret.", new Object[]{e});
        }
    }

    @Override
    public void encrypt(InputStream clearTextData, OutputStream encryptedData, EncryptionKey key) {
        this.doCrypt(clearTextData, encryptedData, key, 1);
    }

    @Override
    public void decrypt(InputStream encryptedData, OutputStream clearTextData, EncryptionKey key) {
        this.doCrypt(encryptedData, clearTextData, key, 2);
    }

    protected void doCrypt(InputStream input, OutputStream output, EncryptionKey key, int mode) {
        Assertions.assertNotNull(key, "key must not be null.", new Object[0]);
        if (input == null) {
            throw new Assertions.AssertionException("input must not be null.", new Object[0]);
        }
        if (output == null) {
            throw new Assertions.AssertionException("output must not be null.", new Object[0]);
        }
        try {
            Cipher cipher = Cipher.getInstance(String.valueOf(this.getCipherAlgorithm()) + "/" + this.getCipherAlgorithmMode() + "/" + this.getCipherAlgorithmPadding(), this.getCipherAlgorithmProvider());
            cipher.init(mode, key.get(), key.params());
            Throwable throwable = null;
            Object var7_10 = null;
            try (CipherOutputStream out = new CipherOutputStream(output, cipher);){
                int n;
                byte[] buf = new byte[8192];
                while ((n = input.read(buf)) >= 0) {
                    ((OutputStream)out).write(buf, 0, n);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProcessingException("Unable to crypt data. Algorithm could not be found. Make sure to use JRE 1.8 or newer.", new Object[]{e});
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new ProcessingException("Unable to crypt data.", new Object[]{e});
        }
    }

    @Override
    public SecureRandom createSecureRandom() {
        return new SecureRandom();
    }

    @Override
    public byte[] createSecureRandomBytes(int numBytes) {
        Assertions.assertGreater(numBytes, 0, "{} is not a valid number for random bytes.", numBytes);
        byte[] rnd = new byte[numBytes];
        this.createSecureRandom().nextBytes(rnd);
        return rnd;
    }

    @Override
    public byte[] createPasswordHash(char[] password, byte[] salt, int iterations) {
        Assertions.assertGreater(Assertions.assertNotNull(password, "password must not be null.", new Object[0]).length, 0, "empty password is not allowed.", new Object[0]);
        Assertions.assertGreater(Assertions.assertNotNull(salt, "salt must not be null.", new Object[0]).length, 0, "empty salt is not allowed.", new Object[0]);
        Assertions.assertGreaterOrEqual(iterations, 10000, "iterations must be > {}", 10000);
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(this.getPasswordHashSecretKeyAlgorithm(), this.getCipherAlgorithmProvider());
            PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, 256);
            SecretKey key = skf.generateSecret(spec);
            byte[] res = key.getEncoded();
            return res;
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new ProcessingException("Unable to create password hash.", new Object[]{e});
        }
    }

    @Override
    public byte[] createHash(InputStream data, byte[] salt, int iterations) {
        if (data == null) {
            throw new Assertions.AssertionException("no data provided", new Object[0]);
        }
        try {
            int n;
            MessageDigest digest = MessageDigest.getInstance(this.getDigestAlgorithm(), this.getDigestAlgorithmProvider());
            digest.reset();
            if (salt != null && salt.length > 0) {
                digest.update(salt);
            }
            byte[] buf = new byte[8192];
            while ((n = data.read(buf)) >= 0) {
                digest.update(buf, 0, n);
            }
            byte[] key = digest.digest();
            int i = 1;
            while (i < iterations) {
                key = digest.digest(key);
                digest.reset();
                ++i;
            }
            return key;
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new ProcessingException("Unable to hash.", new Object[]{e});
        }
    }

    @Override
    public KeyPairBytes createKeyPair() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(this.getKeyPairGenerationAlgorithm(), this.getSignatureProvider());
            ECGenParameterSpec spec = new ECGenParameterSpec(this.getEllipticCurveName());
            keyGen.initialize(spec, SecureRandom.getInstanceStrong());
            KeyPair keyPair = keyGen.generateKeyPair();
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyPair.getPublic().getEncoded());
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyPair.getPrivate().getEncoded());
            return new KeyPairBytes(pkcs8EncodedKeySpec.getEncoded(), x509EncodedKeySpec.getEncoded());
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new ProcessingException("unable to create a new key-pair", new Object[]{e});
        }
    }

    @Override
    public byte[] createSignature(byte[] privateKey, InputStream data) {
        Assertions.assertGreater(Assertions.assertNotNull(privateKey, "no private key provided", new Object[0]).length, 0, "empty private key not allowed", new Object[0]);
        if (data == null) {
            throw new Assertions.AssertionException("no data provided", new Object[0]);
        }
        try {
            int n;
            KeyFactory keyFactory = KeyFactory.getInstance(this.getKeyPairGenerationAlgorithm(), this.getSignatureProvider());
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKey);
            PrivateKey priv = keyFactory.generatePrivate(privateKeySpec);
            Signature sig = Signature.getInstance(this.getSignatureAlgorithm(), this.getSignatureProvider());
            sig.initSign(priv, this.createSecureRandom());
            byte[] buf = new byte[8192];
            while ((n = data.read(buf)) >= 0) {
                sig.update(buf, 0, n);
            }
            return sig.sign();
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | InvalidKeySpecException e) {
            throw new ProcessingException("unable to create signature.", new Object[]{e});
        }
    }

    @Override
    public boolean verifySignature(byte[] publicKey, InputStream data, byte[] signatureToVerify) {
        Assertions.assertGreater(Assertions.assertNotNull(publicKey, "no public key provided", new Object[0]).length, 0, "empty public key not allowed", new Object[0]);
        Assertions.assertGreater(Assertions.assertNotNull(signatureToVerify, "no signature provided", new Object[0]).length, 0, "empty signature not allowed", new Object[0]);
        if (data == null) {
            throw new Assertions.AssertionException("no data provided", new Object[0]);
        }
        try {
            int n;
            KeyFactory keyFactory = KeyFactory.getInstance(this.getKeyPairGenerationAlgorithm(), this.getSignatureProvider());
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(publicKey);
            PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
            Signature sig = Signature.getInstance(this.getSignatureAlgorithm(), this.getSignatureProvider());
            sig.initVerify(pubKey);
            byte[] buf = new byte[8192];
            while ((n = data.read(buf)) >= 0) {
                sig.update(buf, 0, n);
            }
            return sig.verify(signatureToVerify);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | InvalidKeySpecException t) {
            throw new ProcessingException("unable to verify signature", new Object[]{t});
        }
    }

    @Override
    public byte[] createMac(byte[] password, InputStream data) {
        Assertions.assertGreater(Assertions.assertNotNull(password, "no password provided", new Object[0]).length, 0, "empty password not allowed", new Object[0]);
        if (data == null) {
            throw new Assertions.AssertionException("no data provided", new Object[0]);
        }
        try {
            int n;
            String algorithm = this.getMacAlgorithm();
            SecretKeySpec key = new SecretKeySpec(password, 0, password.length, algorithm);
            Mac mac = Mac.getInstance(algorithm, this.getMacAlgorithmProvider());
            mac.init(key);
            byte[] buf = new byte[8192];
            while ((n = data.read(buf)) >= 0) {
                mac.update(buf, 0, n);
            }
            return mac.doFinal();
        }
        catch (IOException | IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new ProcessingException("unable to create signature.", new Object[]{e});
        }
    }

    protected String getMacAlgorithm() {
        return "HmacSHA256";
    }

    protected String getMacAlgorithmProvider() {
        return "SunJCE";
    }

    protected int getKeyDerivationIterationCount() {
        return 3557;
    }

    protected String getSignatureAlgorithm() {
        return "SHA512withECDSA";
    }

    protected String getSignatureProvider() {
        return "SunEC";
    }

    protected String getKeyPairGenerationAlgorithm() {
        return "EC";
    }

    protected String getEllipticCurveName() {
        return "secp256k1";
    }

    protected String getDigestAlgorithm() {
        return "SHA-512";
    }

    protected String getDigestAlgorithmProvider() {
        return "SUN";
    }

    protected String getSecretKeyAlgorithm() {
        return "PBKDF2WithHmacSHA256";
    }

    protected String getPasswordHashSecretKeyAlgorithm() {
        return "PBKDF2WithHmacSHA512";
    }

    protected String getCipherAlgorithm() {
        return "AES";
    }

    protected String getCipherAlgorithmProvider() {
        return "SunJCE";
    }

    protected String getCipherAlgorithmMode() {
        return "GCM";
    }

    protected String getCipherAlgorithmPadding() {
        return "PKCS5Padding";
    }
}

