/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.reflect;

import java.lang.reflect.Method;
import org.eclipse.scout.rt.platform.reflect.FastBeanUtility;

public class FastPropertyDescriptor {
    private final Class<?> m_beanClass;
    private final String m_name;
    private Class<?> m_propertyType;
    private Method m_readMethod;
    private Method m_writeMethod;

    public FastPropertyDescriptor(Class<?> beanClazz, String name, Method readMethod, Method writeMethod) {
        this.m_beanClass = beanClazz;
        this.m_name = name;
        this.m_readMethod = readMethod;
        this.m_writeMethod = writeMethod;
        this.m_propertyType = FastBeanUtility.findPropertyType(readMethod, writeMethod);
    }

    FastPropertyDescriptor(Class<?> beanClazz, String name) {
        this.m_beanClass = beanClazz;
        this.m_name = name;
    }

    public Class getBeanClass() {
        return this.m_beanClass;
    }

    public String getName() {
        return this.m_name;
    }

    public Class<?> getPropertyType() {
        return this.m_propertyType;
    }

    public Method getReadMethod() {
        return this.m_readMethod;
    }

    void addReadMethod(Method newMethod) {
        if (this.m_readMethod != null && this.m_propertyType != null && newMethod.getReturnType().isAssignableFrom(this.m_propertyType)) {
            return;
        }
        this.m_readMethod = newMethod;
        this.m_propertyType = this.m_readMethod.getReturnType();
        if (this.m_writeMethod != null && !this.m_propertyType.isAssignableFrom(this.m_writeMethod.getParameterTypes()[0])) {
            this.m_writeMethod = null;
        }
    }

    public Method getWriteMethod() {
        return this.m_writeMethod;
    }

    void addWriteMethod(Method newMethod) {
        if (this.m_writeMethod != null && newMethod.getParameterTypes()[0].isAssignableFrom(this.m_writeMethod.getParameterTypes()[0])) {
            return;
        }
        if (this.m_propertyType == null) {
            this.m_writeMethod = newMethod;
            this.m_propertyType = this.m_writeMethod.getParameterTypes()[0];
        } else if (this.m_propertyType.isAssignableFrom(newMethod.getParameterTypes()[0])) {
            this.m_writeMethod = newMethod;
        }
    }

    public int hashCode() {
        int result = 0;
        result ^= this.getName().hashCode();
        result ^= this.getPropertyType() == null ? 0 : this.getPropertyType().hashCode();
        result ^= this.getReadMethod() == null ? 0 : this.getReadMethod().hashCode();
        return result ^= this.getWriteMethod() == null ? 0 : this.getWriteMethod().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FastPropertyDescriptor other = (FastPropertyDescriptor)obj;
        Method otherReadMethod = other.getReadMethod();
        Method otherWriteMethod = other.getWriteMethod();
        if (!FastBeanUtility.compareMethods(this.getReadMethod(), otherReadMethod)) {
            return false;
        }
        if (!FastBeanUtility.compareMethods(this.getWriteMethod(), otherWriteMethod)) {
            return false;
        }
        return this.getPropertyType() == other.getPropertyType();
    }

    public String toString() {
        return "FastPropertyDescriptor [" + this.m_beanClass + " / " + this.m_name + "]";
    }
}

