/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.reflect.FastPropertyDescriptor;

public final class FastBeanUtility {
    private static final Pattern BEAN_METHOD_PAT = Pattern.compile("(get|set|is)([A-Z].*)");

    private FastBeanUtility() {
    }

    public static String capitalize(String s) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        return String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1);
    }

    public static String decapitalize(String s) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        if (s.length() >= 2 && Character.isUpperCase(s.charAt(0)) && Character.isUpperCase(s.charAt(1))) {
            return s;
        }
        return String.valueOf(Character.toLowerCase(s.charAt(0))) + s.substring(1);
    }

    public static boolean compareMethods(Method a, Method b) {
        if (a == null != (b == null)) {
            return false;
        }
        return a == null || a.equals(b);
    }

    public static Class findPropertyType(Method readMethod, Method writeMethod) {
        if (readMethod != null) {
            return readMethod.getReturnType();
        }
        if (writeMethod != null) {
            return writeMethod.getParameterTypes()[0];
        }
        return null;
    }

    public static Map<String, FastPropertyDescriptor> createPropertyDescriptorMap(Class<?> beanClazz, Class<?> stopClazz) {
        HashMap<String, FastPropertyDescriptor> map = new HashMap<String, FastPropertyDescriptor>();
        Class<?> cl = beanClazz;
        while (cl != null && cl != stopClazz) {
            Method[] methods = FastBeanUtility.getDeclaredPublicMethods(cl);
            FastBeanUtility.contributePropertyDescriptors(beanClazz, cl, methods, map);
            cl = cl.getSuperclass();
        }
        return map;
    }

    public static void contributePropertyDescriptors(Class<?> beanClazz, Class<?> aSuperClass, Method[] methods, Map<String, FastPropertyDescriptor> contributeMap) {
        if (methods == null || methods.length == 0) {
            return;
        }
        Method[] methodArray = methods;
        int n2 = methods.length;
        int n3 = 0;
        while (n3 < n2) {
            Matcher matcher;
            Method m = methodArray[n3];
            if (m != null && (matcher = BEAN_METHOD_PAT.matcher(m.getName())).matches()) {
                FastPropertyDescriptor desc;
                String kind = matcher.group(1);
                String name = FastBeanUtility.decapitalize(matcher.group(2));
                Class<?>[] paramTypes = m.getParameterTypes();
                Class<?> retType = m.getReturnType();
                if ("get".equals(kind) && paramTypes.length == 0 && retType != null && retType != Void.TYPE) {
                    desc = contributeMap.computeIfAbsent(name, n -> new FastPropertyDescriptor(beanClazz, (String)n));
                    desc.addReadMethod(m);
                } else if ("is".equals(kind) && paramTypes.length == 0 && retType != null && retType == Boolean.TYPE) {
                    desc = contributeMap.computeIfAbsent(name, n -> new FastPropertyDescriptor(beanClazz, (String)n));
                    desc.addReadMethod(m);
                } else if ("set".equals(kind) && paramTypes.length == 1 && (retType == null || retType == Void.TYPE)) {
                    desc = contributeMap.computeIfAbsent(name, n -> new FastPropertyDescriptor(beanClazz, (String)n));
                    desc.addWriteMethod(m);
                }
            }
            ++n3;
        }
    }

    public static Method[] getDeclaredPublicMethods(Class c) {
        Method[] methods = null;
        Class fc = c;
        methods = AccessController.doPrivileged(fc::getDeclaredMethods);
        ArrayList<Method> methodsList = new ArrayList<Method>();
        if (methods != null) {
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                int mods = method.getModifiers();
                if (Modifier.isPublic(mods)) {
                    methodsList.add(method);
                }
                ++n2;
            }
        }
        return methodsList.toArray(new Method[methodsList.size()]);
    }
}

