/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.nls;

import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.scout.rt.platform.nls.NlsResourceBundle;
import org.eclipse.scout.rt.platform.util.Assertions;

public class NlsResourceBundleCache {
    private final String m_resourceBundleName;
    private final Class<?> m_wrapperClass;
    private final ConcurrentMap<Locale, NlsResourceBundle> m_resourceBundles;
    private static final NlsResourceBundle NONEXISTENT_BUNDLE = new NlsResourceBundle(null, Collections.emptyMap());

    public NlsResourceBundleCache(String resourceBundleName, Class wrapperClass) {
        this.m_resourceBundleName = resourceBundleName;
        this.m_wrapperClass = wrapperClass;
        this.m_resourceBundles = new ConcurrentHashMap<Locale, NlsResourceBundle>();
    }

    public Class<?> getWrapperClass() {
        return this.m_wrapperClass;
    }

    public NlsResourceBundle getResourceBundle(Locale locale) {
        Assertions.assertNotNull(locale);
        NlsResourceBundle resourceBundle = (NlsResourceBundle)this.m_resourceBundles.get(locale);
        if (resourceBundle == NONEXISTENT_BUNDLE) {
            return null;
        }
        if (resourceBundle != null) {
            return resourceBundle;
        }
        resourceBundle = this.loadBundle(locale);
        if (resourceBundle == null) {
            this.m_resourceBundles.put(locale, NONEXISTENT_BUNDLE);
            return null;
        }
        NlsResourceBundle r = this.m_resourceBundles.putIfAbsent(locale, resourceBundle);
        return r != null ? r : resourceBundle;
    }

    protected NlsResourceBundle loadBundle(Locale locale) {
        if (Locale.ROOT.equals(locale)) {
            return NlsResourceBundle.getBundle(null, this.m_resourceBundleName, locale, this.m_wrapperClass.getClassLoader());
        }
        NlsResourceBundle parentBundle = this.getResourceBundle(this.getParentLocale(locale));
        NlsResourceBundle bundle = NlsResourceBundle.getBundle(parentBundle, this.m_resourceBundleName, locale, this.m_wrapperClass.getClassLoader());
        return bundle != null ? bundle : parentBundle;
    }

    protected Locale getParentLocale(Locale locale) {
        String tag = locale.toLanguageTag();
        int idx = tag.lastIndexOf(45);
        if (idx > 0) {
            String parentTag = tag.substring(0, idx);
            return Locale.forLanguageTag(parentTag);
        }
        return Locale.ROOT;
    }
}

