/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.nls;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NlsResourceBundle {
    private static final Logger LOG = LoggerFactory.getLogger(NlsResourceBundle.class);
    private static final String TEXT_RESOURCE_EXTENSION = "properties";
    private final NlsResourceBundle m_parent;
    private final Map<String, String> m_textMap;

    public NlsResourceBundle(NlsResourceBundle parent, Map<String, String> textMap) {
        this.m_parent = parent;
        Assertions.assertFalse(textMap.containsKey(null));
        Assertions.assertFalse(textMap.containsValue(null));
        this.m_textMap = Collections.unmodifiableMap(textMap);
    }

    public NlsResourceBundle getParent() {
        return this.m_parent;
    }

    public Map<String, String> getTextMap() {
        return this.m_textMap;
    }

    void collectTextMapping(BiConsumer<String, String> collector) {
        NlsResourceBundle rb = this;
        while (rb != null) {
            for (Map.Entry<String, String> e : rb.m_textMap.entrySet()) {
                collector.accept(e.getKey(), e.getValue());
            }
            rb = rb.m_parent;
        }
    }

    public String getText(String key) {
        Assertions.assertNotNull(key);
        NlsResourceBundle rb = this;
        while (rb != null) {
            String value = rb.m_textMap.get(key);
            if (value != null) {
                return value;
            }
            rb = rb.m_parent;
        }
        return null;
    }

    public static NlsResourceBundle getBundle(NlsResourceBundle parent, String baseName, Locale locale, ClassLoader cl) {
        String suffix = NlsResourceBundle.getLocaleSuffix(locale);
        try {
            return NlsResourceBundle.getBundle(parent, baseName, suffix, cl);
        }
        catch (IOException e) {
            LOG.warn("Error loading nls resource with base name '{}' and suffix '{}'", new Object[]{baseName, suffix, e});
            return null;
        }
    }

    private static String getLocaleSuffix(Locale locale) {
        if (locale == null || Locale.ROOT.equals(locale)) {
            return "";
        }
        return "_" + locale.toString();
    }

    private static NlsResourceBundle getBundle(NlsResourceBundle parent, String baseName, String suffix, ClassLoader cl) throws IOException {
        String fileName = String.valueOf(baseName.replace('.', '/')) + suffix + '.' + TEXT_RESOURCE_EXTENSION;
        URL res = cl.getResource(fileName);
        if (res != null) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (InputStream in = res.openStream();){
                return new NlsResourceBundle(parent, NlsResourceBundle.loadTextMap(in));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    private static Map<String, String> loadTextMap(InputStream stream) throws IOException {
        Properties properties = new Properties();
        properties.load(stream);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        return map;
    }
}

