/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.nls;

import java.util.Locale;

public final class NlsLocale {
    public static final ThreadLocal<Locale> CURRENT = new ThreadLocal();

    private NlsLocale() {
    }

    public static Locale get() {
        return NlsLocale.getOrElse(Locale.getDefault());
    }

    public static Locale getOrElse(Locale defaultLocale) {
        Locale locale = CURRENT.get();
        if (locale != null) {
            return locale;
        }
        return defaultLocale;
    }

    public static void set(Locale locale) {
        if (locale == null) {
            CURRENT.remove();
        } else {
            CURRENT.set(locale);
        }
    }
}

