/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.logger;

import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.eclipse.scout.rt.platform.logger.AbstractLoggerSupport;
import org.eclipse.scout.rt.platform.logger.ILoggerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4jLoggerSupport
extends AbstractLoggerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(Log4jLoggerSupport.class);

    @Override
    public ILoggerSupport.LogLevel getLogLevel(String name) {
        org.apache.log4j.Logger log4jLogger = this.getLog4jLogger(name);
        Level log4jLevel = log4jLogger.getLevel();
        return this.log4jToScoutLevel(log4jLevel);
    }

    @Override
    public void setLogLevel(String name, ILoggerSupport.LogLevel level) {
        Level log4jLevel = this.scoutToLog4jLevel(level);
        org.apache.log4j.Logger log4jLogger = this.getLog4jLogger(name);
        log4jLogger.setLevel(log4jLevel);
    }

    protected org.apache.log4j.Logger getLog4jLogger(String name) {
        if (name.equalsIgnoreCase("ROOT")) {
            return LogManager.getRootLogger();
        }
        return LogManager.getLogger((String)name);
    }

    protected ILoggerSupport.LogLevel log4jToScoutLevel(Level level) {
        if (level == null) {
            return null;
        }
        switch (level.toInt()) {
            case -2147483648: {
                return ILoggerSupport.LogLevel.ALL;
            }
            case 5000: {
                return ILoggerSupport.LogLevel.TRACE;
            }
            case 10000: {
                return ILoggerSupport.LogLevel.DEBUG;
            }
            case 20000: {
                return ILoggerSupport.LogLevel.INFO;
            }
            case 30000: {
                return ILoggerSupport.LogLevel.WARN;
            }
            case 40000: 
            case 50000: {
                return ILoggerSupport.LogLevel.ERROR;
            }
            case 0x7FFFFFFF: {
                return ILoggerSupport.LogLevel.OFF;
            }
        }
        LOG.info("unknown log4j level '{}'. Falling back to scout log level '{}'", (Object)level, (Object)ILoggerSupport.LogLevel.WARN);
        return ILoggerSupport.LogLevel.WARN;
    }

    protected Level scoutToLog4jLevel(ILoggerSupport.LogLevel level) {
        if (level == null) {
            return null;
        }
        switch (level) {
            case ALL: {
                return Level.ALL;
            }
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case OFF: {
                return Level.OFF;
            }
        }
        LOG.info("unknown scout log level '{}'. Falling back to log4j level '{}'", (Object)level, (Object)Level.WARN);
        return Level.WARN;
    }
}

