/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.internal;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class NamedThreadFactory
implements ThreadFactory,
Thread.UncaughtExceptionHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(NamedThreadFactory.class);
    private final AtomicLong m_sequence;
    private final String m_threadName;
    private final ThreadGroup m_group;

    public NamedThreadFactory(String threadName) {
        this.m_threadName = threadName;
        this.m_sequence = new AtomicLong();
        SecurityManager securityManager = System.getSecurityManager();
        this.m_group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        final AtomicReference<ThreadInfo> threadInfoRef = new AtomicReference<ThreadInfo>();
        Thread thread = new Thread(this.m_group, runnable, this.m_threadName, 0L){

            @Override
            public void run() {
                MDC.clear();
                ThreadInfo.CURRENT.set((ThreadInfo)threadInfoRef.get());
                try {
                    super.run();
                }
                finally {
                    ThreadInfo.CURRENT.remove();
                }
            }
        };
        threadInfoRef.set(new ThreadInfo(thread, this.m_threadName, this.m_sequence.incrementAndGet()));
        thread.setDaemon(false);
        thread.setPriority(5);
        thread.setUncaughtExceptionHandler(this);
        return thread;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable t) {
        try {
            BEANS.get(ExceptionHandler.class).handle(t);
        }
        catch (Throwable unhandledThrowable) {
            LOG.error("Unexpected: Unhandled throwable during job execution", unhandledThrowable);
        }
    }

    public static class ThreadInfo {
        public static final ThreadLocal<ThreadInfo> CURRENT = new ThreadLocal();
        private final Thread m_thread;
        private final String m_originalThreadName;
        private final long m_sequence;

        public ThreadInfo(Thread thread, String threadName, long sequence) {
            this.m_thread = thread;
            this.m_originalThreadName = threadName;
            this.m_sequence = sequence;
            this.reset();
        }

        public void reset() {
            this.updateThreadName(this.m_originalThreadName, null);
        }

        public void updateThreadName(String threadName, String executionInfo) {
            String name = String.format("%s-%s", ObjectUtility.nvl(threadName, this.m_originalThreadName), this.m_sequence);
            if (StringUtility.hasText(executionInfo)) {
                name = String.format("%s %s", name, executionInfo);
            }
            this.m_thread.setName(name);
        }
    }
}

