/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.internal;

import java.security.AccessController;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.IExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.IThrowableWithContextInfo;
import org.eclipse.scout.rt.platform.security.SecurityUtility;
import org.eclipse.scout.rt.platform.util.concurrent.FutureCancelledError;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.platform.util.concurrent.TimedOutError;

@ApplicationScoped
public class JobExceptionTranslator {
    protected FutureCancelledError translateCancellationException(CancellationException e, String message) {
        return this.decorate(new FutureCancelledError(message, new Object[]{e}));
    }

    protected ThreadInterruptedError translateInterruptedException(InterruptedException e, String message) {
        return this.decorate(new ThreadInterruptedError(message, new Object[]{e}));
    }

    protected TimedOutError translateTimeoutException(TimeoutException e, String message, long timeout, TimeUnit unit) {
        return this.decorate(new TimedOutError(message, new Object[]{e}).withContextInfo("timeout", "{}ms", unit.toMillis(timeout)));
    }

    protected <EXCEPTION extends Throwable> EXCEPTION translateExecutionException(ExecutionException e, Class<? extends IExceptionTranslator<EXCEPTION>> translator) {
        return this.decorate(BEANS.get(translator).translate(e));
    }

    protected <EXCEPTION extends Throwable> EXCEPTION decorate(EXCEPTION exception) {
        if (exception instanceof IThrowableWithContextInfo) {
            ((IThrowableWithContextInfo)((Object)exception)).withContextInfo("user", SecurityUtility.getPrincipalNames(Subject.getSubject(AccessController.getContext())), new Object[0]).withContextInfo("calling-thread", Thread.currentThread().getName(), new Object[0]);
        }
        return exception;
    }
}

