/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.config.PlatformConfigProperties;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.IJobManager;
import org.eclipse.scout.rt.platform.job.internal.CompletionPromise;
import org.eclipse.scout.rt.platform.job.internal.JobFutureTask;
import org.eclipse.scout.rt.platform.job.listener.JobEvent;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.IRegistrationHandle;

@Bean
public class FutureSet {
    private final Set<JobFutureTask<?>> m_futures = new HashSet((Integer)CONFIG.getPropertyValue(PlatformConfigProperties.JobManagerCorePoolSizeProperty.class));
    private final ReentrantReadWriteLock.ReadLock m_readLock;
    private final ReentrantReadWriteLock.WriteLock m_writeLock;
    private final Condition m_changedCondition;
    private IRegistrationHandle m_jobListenerRegistration;

    public FutureSet() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.m_readLock = lock.readLock();
        this.m_writeLock = lock.writeLock();
        this.m_changedCondition = this.m_writeLock.newCondition();
    }

    public void init(IJobManager jobManager) {
        this.m_jobListenerRegistration = jobManager.addListener(this.newSignalingFilter(), event -> {
            this.m_writeLock.lock();
            try {
                this.m_changedCondition.signalAll();
            }
            finally {
                this.m_writeLock.unlock();
            }
        });
    }

    public void dispose() {
        List<JobFutureTask<?>> runningFutures;
        this.m_jobListenerRegistration.dispose();
        this.m_writeLock.lock();
        try {
            runningFutures = this.copyFutures();
            this.m_futures.clear();
            this.m_changedCondition.signalAll();
        }
        finally {
            this.m_writeLock.unlock();
        }
        for (JobFutureTask<?> runningFuture : runningFutures) {
            runningFuture.cancel(true);
        }
    }

    public void add(JobFutureTask<?> future) {
        this.m_writeLock.lock();
        try {
            this.m_futures.add(future);
            this.m_changedCondition.signalAll();
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    public void remove(JobFutureTask<?> future) {
        this.m_writeLock.lock();
        try {
            this.m_futures.remove(future);
            this.m_changedCondition.signalAll();
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    public boolean matchesEvery(Predicate<IFuture<?>> filter, Predicate<JobFutureTask<?>> matcher) {
        for (JobFutureTask<?> future : this.copyFutures()) {
            boolean accepted;
            boolean bl = accepted = filter == null || filter.test(future);
            if (!accepted || matcher.test(future)) continue;
            return false;
        }
        return true;
    }

    public boolean containsSome(Predicate<IFuture<?>> filter) {
        for (JobFutureTask<?> future : this.copyFutures()) {
            if (filter != null && !filter.test(future)) continue;
            return true;
        }
        return false;
    }

    public void awaitDone(Predicate<IFuture<?>> filter, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        Assertions.assertGreater(timeout, 0L, "Invalid timeout; must be > 0 [timeout={}]", timeout);
        this.m_writeLock.lockInterruptibly();
        try {
            long nanos = unit.toNanos(timeout);
            while (!this.matchesEvery(filter, CompletionPromise.PROMISE_DONE_MATCHER) && nanos > 0L) {
                nanos = this.m_changedCondition.awaitNanos(nanos);
            }
            if (nanos <= 0L) {
                throw new TimeoutException();
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    public void awaitFinished(Predicate<IFuture<?>> filter, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        Assertions.assertGreater(timeout, 0L, "Invalid timeout; must be > 0 [timeout={}]", timeout);
        this.m_writeLock.lockInterruptibly();
        try {
            long nanos = unit.toNanos(timeout);
            while (this.containsSome(filter) && nanos > 0L) {
                nanos = this.m_changedCondition.awaitNanos(nanos);
            }
            if (nanos <= 0L) {
                throw new TimeoutException();
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    public final Set<IFuture<?>> values(Predicate<IFuture<?>> filter) {
        HashSet futures = new HashSet();
        for (IFuture iFuture : this.copyFutures()) {
            if (filter != null && !filter.test(iFuture)) continue;
            futures.add(iFuture);
        }
        return futures;
    }

    public boolean cancel(Predicate<IFuture<?>> filter, boolean interruptIfRunning) {
        HashSet<Boolean> success = new HashSet<Boolean>();
        for (IFuture<?> future : this.values(filter)) {
            success.add(future.cancel(interruptIfRunning));
        }
        return Collections.singleton(Boolean.TRUE).equals(success);
    }

    protected List<JobFutureTask<?>> copyFutures() {
        this.m_readLock.lock();
        try {
            ArrayList arrayList = new ArrayList(this.m_futures);
            return arrayList;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    protected Predicate<JobEvent> newSignalingFilter() {
        return event -> {
            switch (event.getType()) {
                case JOB_EXECUTION_HINT_ADDED: 
                case JOB_EXECUTION_HINT_REMOVED: {
                    return true;
                }
                case JOB_STATE_CHANGED: {
                    switch (event.getData().getState()) {
                        case PENDING: 
                        case RUNNING: 
                        case WAITING_FOR_PERMIT: 
                        case WAITING_FOR_BLOCKING_CONDITION: 
                        case DONE: {
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        };
    }
}

