/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.internal;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.job.FixedDelayScheduleBuilder;
import org.eclipse.scout.rt.platform.job.IFixedDelayTrigger;
import org.quartz.Calendar;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.impl.triggers.AbstractTrigger;

public class FixedDelayTrigger
extends AbstractTrigger<IFixedDelayTrigger>
implements IFixedDelayTrigger {
    private static final long serialVersionUID = 1L;
    private static final Date TIME_IN_FUTURE = new Date(Long.MAX_VALUE);
    private long m_fixedDelay;
    private long m_repeatCount;
    private Date m_startTime;
    private Date m_endTime;
    private Date m_previousFireTime;
    private Date m_nextFireTime;
    private long m_triggeredCount;

    @Override
    public long getRepeatCount() {
        return this.m_repeatCount;
    }

    public FixedDelayTrigger withRepeatCount(long repeatCount) {
        this.m_repeatCount = repeatCount;
        return this;
    }

    @Override
    public long getFixedDelay() {
        return this.m_fixedDelay;
    }

    public FixedDelayTrigger withFixedDelay(long fixedDelay) {
        this.m_fixedDelay = fixedDelay;
        return this;
    }

    public void triggered(Calendar calendar) {
        ++this.m_triggeredCount;
        this.m_previousFireTime = this.m_nextFireTime;
        this.m_nextFireTime = this.m_triggeredCount == this.m_repeatCount ? null : (this.m_endTime != null && this.m_endTime.before(new Date(System.currentTimeMillis())) ? null : TIME_IN_FUTURE);
    }

    public Trigger.CompletedExecutionInstruction executionComplete(JobExecutionContext context, JobExecutionException result) {
        if (TIME_IN_FUTURE.equals(this.m_nextFireTime)) {
            this.m_nextFireTime = new Date(System.currentTimeMillis() + this.m_fixedDelay);
        }
        return Trigger.CompletedExecutionInstruction.NOOP;
    }

    public Date computeFirstFireTime(Calendar calendar) {
        this.m_nextFireTime = this.m_startTime;
        return this.m_startTime;
    }

    public Date getFinalFireTime() {
        if (this.m_repeatCount == 0L) {
            return this.m_startTime;
        }
        return null;
    }

    public boolean mayFireAgain() {
        return this.m_nextFireTime != null;
    }

    public Date getFireTimeAfter(Date afterTime) {
        throw new UnsupportedOperationException();
    }

    public Date getNextFireTime() {
        return this.m_nextFireTime;
    }

    public void setNextFireTime(Date nextFireTime) {
        this.m_nextFireTime = nextFireTime;
    }

    public Date getPreviousFireTime() {
        return this.m_previousFireTime;
    }

    public void setPreviousFireTime(Date previousFireTime) {
        this.m_previousFireTime = previousFireTime;
    }

    public Date getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(Date startTime) {
        FixedDelayTrigger.assertNotNull(startTime, "Start time cannot be null");
        FixedDelayTrigger.assertStartEndTime(startTime, this.m_endTime);
        this.m_startTime = startTime;
    }

    public Date getEndTime() {
        return this.m_endTime;
    }

    public void setEndTime(Date endTime) {
        FixedDelayTrigger.assertStartEndTime(this.m_startTime, endTime);
        this.m_endTime = endTime;
    }

    protected boolean validateMisfireInstruction(int candidateMisfireInstruction) {
        return false;
    }

    public void updateAfterMisfire(Calendar cal) {
    }

    public void updateWithNewCalendar(Calendar cal, long misfireThreshold) {
    }

    public ScheduleBuilder<IFixedDelayTrigger> getScheduleBuilder() {
        return FixedDelayScheduleBuilder.repeatForTotalCount(this.m_repeatCount, this.m_fixedDelay, TimeUnit.MILLISECONDS);
    }

    private static void assertStartEndTime(Date startTime, Date endTime) {
        if (startTime != null && endTime != null && endTime.before(startTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
    }

    private static void assertNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }
}

