/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.internal;

import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.IPlatformListener;
import org.eclipse.scout.rt.platform.IgnoreBean;
import org.eclipse.scout.rt.platform.PlatformEvent;
import org.eclipse.scout.rt.platform.Replace;
import org.eclipse.scout.rt.platform.chain.callable.ICallableDecorator;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobState;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.job.internal.NamedThreadFactory;
import org.eclipse.scout.rt.platform.job.internal.ThreadNameDecorator;
import org.eclipse.scout.rt.platform.job.listener.JobEventType;
import org.eclipse.scout.rt.platform.util.IRegistrationHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@IgnoreBean
@Replace
public class DevelopmentThreadNameDecorator
extends ThreadNameDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(DevelopmentThreadNameDecorator.class);

    @Override
    public ICallableDecorator.IUndecorator decorate() throws Exception {
        NamedThreadFactory.ThreadInfo threadInfo = NamedThreadFactory.ThreadInfo.CURRENT.get();
        IFuture<?> future = IFuture.CURRENT.get();
        threadInfo.updateThreadName(future.getJobInput().getThreadName(), this.buildExecutionInfo(future));
        IRegistrationHandle listenerRegistration = future.addListener(Jobs.newEventFilterBuilder().andMatchEventType(JobEventType.JOB_STATE_CHANGED).andMatchState(JobState.RUNNING, JobState.WAITING_FOR_PERMIT, JobState.WAITING_FOR_BLOCKING_CONDITION).toFilter(), event -> threadInfo.updateThreadName(future.getJobInput().getThreadName(), this.buildExecutionInfo(future)));
        return () -> {
            listenerRegistration.dispose();
            threadInfo.reset();
        };
    }

    protected String buildExecutionInfo(IFuture<?> future) {
        switch (future.getState()) {
            case WAITING_FOR_PERMIT: 
            case WAITING_FOR_BLOCKING_CONDITION: {
                return String.format("(%s) %s", future.getState().name(), future.getJobInput().getName());
            }
        }
        return future.getJobInput().getName();
    }

    public static class DevelopmentRegisterer
    implements IPlatformListener {
        @Override
        public void stateChanged(PlatformEvent event) {
            if (event.getState() == IPlatform.State.BeanManagerPrepared && event.getSource().inDevelopmentMode()) {
                LOG.info("+++ Development thread name decoration");
                event.getSource().getBeanManager().registerClass(DevelopmentThreadNameDecorator.class);
            }
        }
    }
}

