/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.internal;

import org.eclipse.scout.rt.platform.chain.callable.CallableChain;
import org.eclipse.scout.rt.platform.chain.callable.ICallableInterceptor;
import org.eclipse.scout.rt.platform.job.internal.CallableChainHandledException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallableChainExceptionHandler<RESULT>
implements ICallableInterceptor<RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(CallableChainExceptionHandler.class);

    @Override
    public RESULT intercept(CallableChain.Chain<RESULT> chain) throws Exception {
        try {
            return chain.continueChain();
        }
        catch (CallableChainHandledException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        catch (Error | Exception err) {
            if (Thread.currentThread().isInterrupted()) {
                LOG.debug("Exception in callable chain due to interruption.", err);
            } else {
                LOG.warn("Exception in callable chain.", err);
            }
            throw err;
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

