/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job;

import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.job.IFixedDelayTrigger;
import org.eclipse.scout.rt.platform.job.internal.FixedDelayTrigger;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.quartz.ScheduleBuilder;
import org.quartz.spi.MutableTrigger;

public final class FixedDelayScheduleBuilder
extends ScheduleBuilder<IFixedDelayTrigger> {
    private final long m_fixedDelay;
    private final long m_repeatCount;

    private FixedDelayScheduleBuilder(long repeatCount, long fixedDelay, TimeUnit unit) {
        Assertions.assertNotEquals(unit, (Object)TimeUnit.NANOSECONDS, "Quartz Scheduler does not support NANOSECONDS as temporal granularity", new Object[0]);
        Assertions.assertGreater(fixedDelay, 0L, "Invalid fixed delay; must be > 0 [fixedDelay={}]", fixedDelay);
        this.m_repeatCount = repeatCount;
        this.m_fixedDelay = unit.toMillis(fixedDelay);
    }

    public long getFixedDelay() {
        return this.m_fixedDelay;
    }

    public long getRepeatCount() {
        return this.m_repeatCount;
    }

    protected MutableTrigger build() {
        return new FixedDelayTrigger().withFixedDelay(this.m_fixedDelay).withRepeatCount(this.m_repeatCount);
    }

    public static FixedDelayScheduleBuilder repeatForever(long fixedDelay, TimeUnit unit) {
        return new FixedDelayScheduleBuilder(-1L, fixedDelay, unit);
    }

    public static FixedDelayScheduleBuilder repeatForTotalCount(long repeatCount, long fixedDelay, TimeUnit unit) {
        return new FixedDelayScheduleBuilder(repeatCount, fixedDelay, unit);
    }
}

