/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.inventory.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.util.SleepUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockedFile
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LockedFile.class);
    private final File m_unsafeFile;
    private final RandomAccessFile m_rwFile;

    public LockedFile(File f) throws IOException {
        this.m_unsafeFile = f;
        this.m_rwFile = new RandomAccessFile(f, "rw");
        this.acquireLock();
    }

    private FileLock acquireLock() throws IOException {
        long timeoutSeconds = 30L;
        long timeoutEvent = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeoutSeconds);
        while (true) {
            try {
                FileLock lock = this.m_rwFile.getChannel().tryLock();
                if (lock != null) {
                    return lock;
                }
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                // empty catch block
            }
            if (timeoutEvent > 0L && System.currentTimeMillis() > timeoutEvent) {
                timeoutEvent = 0L;
                LOG.warn("File '{}' is still locked after {} seconds.", (Object)this.m_unsafeFile.getAbsolutePath(), (Object)timeoutSeconds);
            }
            SleepUtil.sleepSafe(100L, TimeUnit.MILLISECONDS);
        }
    }

    public boolean exists() throws IOException {
        return this.length() > 0L;
    }

    public long length() throws IOException {
        return this.m_rwFile.length();
    }

    public void flush() throws IOException {
        this.m_rwFile.getChannel().force(true);
    }

    public boolean setLastModified(long t) throws IOException {
        this.flush();
        return this.m_unsafeFile.setLastModified(t);
    }

    public long lastModified() throws IOException {
        this.flush();
        return this.m_unsafeFile.lastModified();
    }

    public InputStream newInputStream() throws IOException {
        this.m_rwFile.seek(0L);
        return Channels.newInputStream(this.m_rwFile.getChannel());
    }

    public OutputStream newOutputStream() throws IOException {
        this.m_rwFile.seek(0L);
        this.m_rwFile.setLength(0L);
        return Channels.newOutputStream(this.m_rwFile.getChannel());
    }

    @Override
    public void close() throws IOException {
        this.m_rwFile.close();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.m_unsafeFile + "]";
    }
}

