/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.inventory;

import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.inventory.IClassInventory;
import org.eclipse.scout.rt.platform.inventory.internal.JandexClassInventory;
import org.eclipse.scout.rt.platform.inventory.internal.JandexInventoryBuilder;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.jboss.jandex.IndexView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassInventory {
    private static final Logger LOG = LoggerFactory.getLogger(ClassInventory.class);
    private static final IClassInventory INSTANCE;

    static {
        try {
            long t0 = System.nanoTime();
            JandexInventoryBuilder inventoryBuilder = new JandexInventoryBuilder();
            if (LOG.isInfoEnabled()) {
                LOG.info("Building jandex class inventory using rebuild strategy {}...", (Object)inventoryBuilder.getRebuildStrategy());
            }
            inventoryBuilder.scanAllModules();
            IndexView index = inventoryBuilder.finish();
            long nanos = System.nanoTime() - t0;
            if (LOG.isInfoEnabled()) {
                LOG.info("Finished building jandex class inventory in {} ms. Total class count: {}", (Object)StringUtility.formatNanos(nanos), (Object)index.getKnownClasses().size());
            }
            INSTANCE = new JandexClassInventory(index);
        }
        catch (Exception t) {
            throw new PlatformException("Error while building class inventory", new Object[]{t});
        }
    }

    public static IClassInventory get() {
        return INSTANCE;
    }

    private ClassInventory() {
    }
}

