/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BeanMetaData;
import org.eclipse.scout.rt.platform.CreateImmediately;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.IBeanDecorationFactory;
import org.eclipse.scout.rt.platform.IBeanManager;
import org.eclipse.scout.rt.platform.exception.InitializationException;
import org.eclipse.scout.rt.platform.interceptor.IBeanDecorator;
import org.eclipse.scout.rt.platform.interceptor.internal.BeanProxyImplementor;
import org.eclipse.scout.rt.platform.internal.BeanHierarchy;
import org.eclipse.scout.rt.platform.internal.BeanImplementor;
import org.eclipse.scout.rt.platform.internal.BeanInstanceUtil;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.BeanUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanManagerImplementor
implements IBeanManager {
    private static final Logger LOG = LoggerFactory.getLogger(BeanManagerImplementor.class);
    private final ReentrantReadWriteLock m_lock = new ReentrantReadWriteLock(true);
    private final Map<Class<?>, BeanHierarchy> m_beanHierarchies = new HashMap();
    private IBeanDecorationFactory m_beanDecorationFactory;

    public BeanManagerImplementor() {
        this(null);
    }

    public BeanManagerImplementor(IBeanDecorationFactory f) {
        this.m_beanDecorationFactory = f;
    }

    public ReentrantReadWriteLock getReadWriteLock() {
        return this.m_lock;
    }

    protected void checkAccess() {
    }

    protected <T> List<IBean<T>> querySingle(Class<T> beanClazz) {
        this.m_lock.readLock().lock();
        try {
            this.checkAccess();
            BeanHierarchy h = this.m_beanHierarchies.get(beanClazz);
            if (h == null) {
                List<IBean<T>> list = Collections.emptyList();
                return list;
            }
            List singleBean = h.querySingle();
            List list = this.getDecoratedBeans(singleBean, beanClazz);
            return list;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    protected <T> List<IBean<T>> queryAll(Class<T> beanClazz) {
        this.m_lock.readLock().lock();
        try {
            this.checkAccess();
            BeanHierarchy h = this.m_beanHierarchies.get(beanClazz);
            if (h == null) {
                List<IBean<T>> list = Collections.emptyList();
                return list;
            }
            List allBeans = h.queryAll();
            List list = this.getDecoratedBeans(allBeans, beanClazz);
            return list;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    protected Collection<Class<?>> listImplementedTypes(IBean<?> bean) {
        LinkedHashSet set = new LinkedHashSet(BeanUtility.getInterfacesHierarchy(bean.getBeanClazz(), Object.class));
        Class<?> c = bean.getBeanClazz();
        while (c != null && c != Object.class) {
            set.add(c);
            c = c.getSuperclass();
        }
        set.add(Object.class);
        return set;
    }

    protected <T> List<IBean<T>> getDecoratedBeans(List<IBean<T>> beans, Class<T> beanClazz) {
        IBeanDecorationFactory beanDecorationFactory = this.getBeanDecorationFactory();
        if (beanDecorationFactory == null || !beanClazz.isInterface()) {
            return beans;
        }
        ArrayList<IBean<T>> result = new ArrayList<IBean<T>>(beans.size());
        for (IBean<T> bean : beans) {
            result.add(this.getDecoratedBean(bean, beanClazz, beanDecorationFactory));
        }
        return result;
    }

    protected <T> IBean<T> getDecoratedBean(IBean<T> bean, Class<T> beanClazz, IBeanDecorationFactory beanDecorationFactory) {
        IBeanDecorator<T> decorator = beanDecorationFactory.decorate(bean, beanClazz);
        if (decorator == null) {
            return bean;
        }
        T proxy = new BeanProxyImplementor<T>(bean, decorator, beanClazz).getProxy();
        return this.createBeanImplementor(new BeanMetaData(beanClazz).withInitialInstance(proxy).withAnnotations(bean.getBeanAnnotations().values()));
    }

    @Override
    public <T> IBean<T> registerClass(Class<T> beanClazz) {
        return this.registerBean(new BeanMetaData(beanClazz));
    }

    @Override
    public <T> void unregisterClass(Class<T> beanClazz) {
        for (IBean<T> bean : this.getRegisteredBeans(beanClazz)) {
            if (bean.getBeanClazz() != beanClazz) continue;
            this.unregisterBean(bean);
        }
    }

    @Override
    public <T> IBean<T> registerBean(BeanMetaData beanData) {
        this.m_lock.writeLock().lock();
        try {
            BeanImplementor<T> bean = this.createBeanImplementor(beanData);
            for (Class<?> type : this.listImplementedTypes(bean)) {
                BeanHierarchy h = this.m_beanHierarchies.computeIfAbsent(type, k -> new BeanHierarchy(type));
                h.addBean(bean);
            }
            BeanImplementor<T> beanImplementor = bean;
            return beanImplementor;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    @Override
    public synchronized void unregisterBean(IBean<?> bean) {
        this.m_lock.writeLock().lock();
        try {
            Assertions.assertNotNull(bean);
            for (Class<?> type : this.listImplementedTypes(bean)) {
                BeanHierarchy h = this.m_beanHierarchies.get(type);
                if (h == null) continue;
                h.removeBean(bean);
            }
            if (bean instanceof BeanImplementor) {
                ((BeanImplementor)bean).dispose();
            }
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    @Override
    public <T> List<IBean<T>> getRegisteredBeans(Class<T> beanClazz) {
        this.m_lock.readLock().lock();
        try {
            BeanHierarchy h = this.m_beanHierarchies.get(beanClazz);
            if (h == null) {
                ArrayList<IBean<T>> arrayList = CollectionUtility.emptyArrayList();
                return arrayList;
            }
            ArrayList arrayList = new ArrayList(h.getBeans());
            return arrayList;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    @Override
    public <T> IBean<T> getRegisteredBean(Class<?> beanClazz) {
        this.m_lock.readLock().lock();
        try {
            BeanHierarchy h = this.m_beanHierarchies.get(beanClazz);
            if (h != null) {
                IBean iBean = h.getExactBean(beanClazz);
                return iBean;
            }
            return null;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    @Override
    public <T> IBean<T> getBean(Class<T> beanClazz) {
        IBean<T> result = this.optBean(beanClazz);
        if (result == null) {
            return (IBean)Assertions.fail("no instances found for query: {}", beanClazz);
        }
        return result;
    }

    @Override
    public <T> IBean<T> optBean(Class<T> beanClazz) {
        List<IBean<T>> list = this.querySingle(beanClazz);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.isEmpty()) {
            return null;
        }
        return (IBean)Assertions.fail("multiple instances found for query: {} {}", beanClazz, list);
    }

    @Override
    public <T> IBean<T> uniqueBean(Class<T> beanClazz) {
        List<IBean<T>> list = this.querySingle(beanClazz);
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T> List<IBean<T>> getBeans(Class<T> beanClazz) {
        return this.queryAll(beanClazz);
    }

    protected Set<IBean<?>> getAllBeans() {
        HashSet all = new HashSet();
        for (BeanHierarchy h : this.m_beanHierarchies.values()) {
            all.addAll(h.getBeans());
        }
        return all;
    }

    @Override
    public <T> boolean isBean(Class<T> clazz) {
        this.m_lock.readLock().lock();
        try {
            BeanHierarchy h = this.m_beanHierarchies.get(clazz);
            boolean bl = h != null && !h.getBeans().isEmpty();
            return bl;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    protected void callPreDestroyOnBeans() {
        for (IBean<?> bean : this.getAllBeans()) {
            BeanManagerImplementor.destroyBean(bean);
        }
    }

    protected static void destroyBean(IBean<?> bean) {
        if (!bean.isInstanceAvailable()) {
            return;
        }
        Collection<Method> preDestroyMethods = BeanInstanceUtil.collectPreDestroyMethods(bean.getBeanClazz());
        if (preDestroyMethods.isEmpty()) {
            return;
        }
        if (!BeanManagerImplementor.isApplicationScoped(bean)) {
            LOG.warn("The bean {} declares @PreDestroy methods but is not @ApplicationScoped. These methods will not be called.", bean);
            return;
        }
        Object instance = bean.getInstance();
        for (Method method : preDestroyMethods) {
            LOG.debug("invoking pre-destroy method {}", (Object)method);
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                RuntimeException re = BeanInstanceUtil.translateException("Exception while invoking @PreDestroy method {}", method, e);
                LOG.error("Error invoking @PreDestroy method {} on bean {}.", new Object[]{method, bean, re});
            }
        }
    }

    protected void setBeanDecorationFactory(IBeanDecorationFactory f) {
        this.m_beanDecorationFactory = f;
    }

    protected IBeanDecorationFactory getBeanDecorationFactory() {
        return this.m_beanDecorationFactory;
    }

    protected <T> BeanImplementor<T> createBeanImplementor(BeanMetaData beanData) {
        return new BeanImplementor(beanData);
    }

    public void startCreateImmediatelyBeans() {
        for (IBean<Object> bean : this.getBeans(Object.class)) {
            if (!BeanManagerImplementor.isCreateImmediately(bean)) continue;
            if (BeanManagerImplementor.isApplicationScoped(bean)) {
                bean.getInstance();
                continue;
            }
            throw new InitializationException(String.format("Bean '%s' is marked with @%s and is not application scoped (@%s) - unexpected configuration! ", bean.getBeanClazz(), CreateImmediately.class.getSimpleName(), ApplicationScoped.class.getSimpleName()));
        }
    }

    public static boolean isCreateImmediately(IBean<?> bean) {
        return bean.hasAnnotation(CreateImmediately.class);
    }

    public static boolean isApplicationScoped(IBean<?> bean) {
        return bean.hasAnnotation(ApplicationScoped.class);
    }
}

