/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.InjectBean;
import org.eclipse.scout.rt.platform.exception.BeanCreationException;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanInstanceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BeanInstanceUtil.class);

    private BeanInstanceUtil() {
    }

    public static <T> T createBean(Class<T> beanClazz) {
        Assertions.assertNotNull(beanClazz);
        try {
            Constructor<T> cons = beanClazz.getDeclaredConstructor(new Class[0]);
            cons.setAccessible(true);
            return cons.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw BeanInstanceUtil.translateException("Could not create bean [{}]", beanClazz, e);
        }
    }

    public static Constructor<?> getInjectionConstructor(Class<?> clazz) {
        Constructor<?> result = null;
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> cons = constructorArray[n2];
            if (cons.getAnnotation(InjectBean.class) != null) {
                if (result != null) {
                    throw new BeanCreationException("Found multiple @InjectBean constructors in {}", clazz);
                }
                result = cons;
            }
            ++n2;
        }
        return result;
    }

    public static Object[] getInjectionArguments(Class<?>[] argTypes) {
        Object[] args = new Object[argTypes.length];
        int i = 0;
        while (i < argTypes.length) {
            args[i] = BEANS.get(argTypes[i]);
            ++i;
        }
        return args;
    }

    public static void initializeBeanInstance(Object instance) {
        Collection<Field> fields = BeanInstanceUtil.collectInjectedFields(instance.getClass());
        for (Field field : fields) {
            LOG.debug("injecting field {}", (Object)field);
            try {
                field.setAccessible(true);
                Object value = BEANS.get(field.getType());
                field.set(instance, value);
            }
            catch (Exception e) {
                throw BeanInstanceUtil.translateException("Exception while injecting field {}", field, e);
            }
        }
        Collection<Method> initMethods = BeanInstanceUtil.collectInjectedMethods(instance.getClass());
        for (Method method : initMethods) {
            LOG.debug("invoking injected method {}", (Object)method);
            try {
                method.setAccessible(true);
                method.invoke(instance, BeanInstanceUtil.getInjectionArguments(method.getParameterTypes()));
            }
            catch (Exception e) {
                throw BeanInstanceUtil.translateException("Exception while invoking @InjectBean method {}", method, e);
            }
        }
        Collection<Method> postConstructMethods = BeanInstanceUtil.collectPostConstructMethods(instance.getClass());
        for (Method method : postConstructMethods) {
            LOG.debug("invoking post-construct method {}", (Object)method);
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw BeanInstanceUtil.translateException("Exception while invoking @PostConstruct method {}", method, e);
            }
        }
    }

    static RuntimeException translateException(String message, Object arg, Exception e) {
        Throwable t = e;
        while ((t instanceof UndeclaredThrowableException || t instanceof InvocationTargetException) && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        return new BeanCreationException(message, arg, t);
    }

    static Collection<Method> collectInjectedMethods(Class<?> clazz) {
        return BeanInstanceUtil.collectNonStaticMethodsWithAnnotation(clazz, InjectBean.class, true, true);
    }

    static Collection<Method> collectPostConstructMethods(Class<?> clazz) {
        return BeanInstanceUtil.collectNonStaticMethodsWithAnnotation(clazz, PostConstruct.class, false, true);
    }

    static Collection<Method> collectPreDestroyMethods(Class<?> clazz) {
        return BeanInstanceUtil.collectNonStaticMethodsWithAnnotation(clazz, PreDestroy.class, false, false);
    }

    private static Collection<Method> collectNonStaticMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation, boolean allowArgs, boolean throwOnError) {
        LinkedHashMap<String, Method> collector = new LinkedHashMap<String, Method>();
        Class<?> currentClass = clazz;
        while (currentClass != null && currentClass != Object.class) {
            Method[] methodArray = currentClass.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.isAnnotationPresent(annotation)) {
                    int methodModifiers = m.getModifiers();
                    if (Modifier.isStatic(methodModifiers)) {
                        BeanInstanceUtil.handleError(throwOnError, "Methods annotated with @{} must not be static [method={}]", annotation.getSimpleName(), m);
                    } else if (!allowArgs && m.getParameterTypes().length != 0) {
                        BeanInstanceUtil.handleError(throwOnError, "Methods annotated with @{} must have no arguments [method={}]", annotation.getSimpleName(), m);
                    } else {
                        String name = m.getName();
                        if (Modifier.isPrivate(methodModifiers)) {
                            name = String.valueOf(m.getDeclaringClass().getName()) + ":" + name;
                        }
                        if (!collector.containsKey(name)) {
                            collector.put(name, m);
                        }
                    }
                }
                ++n2;
            }
            currentClass = currentClass.getSuperclass();
        }
        return collector.values();
    }

    static Collection<Field> collectInjectedFields(Class<?> clazz) {
        return BeanInstanceUtil.collectNonStaticFieldsWithAnnotation(clazz, InjectBean.class, false);
    }

    private static Collection<Field> collectNonStaticFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation, boolean throwOnError) {
        LinkedHashMap<String, Field> collector = new LinkedHashMap<String, Field>();
        Class<?> currentClass = clazz;
        while (currentClass != null && currentClass != Object.class) {
            Field[] fieldArray = currentClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (f.isAnnotationPresent(annotation)) {
                    int fieldModifiers = f.getModifiers();
                    if (Modifier.isStatic(fieldModifiers)) {
                        BeanInstanceUtil.handleError(throwOnError, "Fields annotated with @{} must not be static [field={}]", annotation.getSimpleName(), f);
                    } else {
                        String name = f.getName();
                        if (Modifier.isPrivate(fieldModifiers)) {
                            name = String.valueOf(f.getDeclaringClass().getName()) + ":" + name;
                        }
                        if (!collector.containsKey(name)) {
                            collector.put(name, f);
                        }
                    }
                }
                ++n2;
            }
            currentClass = currentClass.getSuperclass();
        }
        return collector.values();
    }

    private static void handleError(boolean throwOnError, String msg, Object ... args) {
        if (throwOnError) {
            throw new BeanCreationException(msg, args);
        }
        LOG.error(msg, args);
    }
}

