/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.interceptor.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.exception.DefaultExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.interceptor.DecoratingProxy;
import org.eclipse.scout.rt.platform.interceptor.IBeanDecorator;
import org.eclipse.scout.rt.platform.interceptor.IBeanInvocationContext;
import org.eclipse.scout.rt.platform.interceptor.IInstanceInvocationHandler;
import org.eclipse.scout.rt.platform.util.Assertions;

public class BeanProxyImplementor<T>
implements IInstanceInvocationHandler<T> {
    private final IBean<T> m_bean;
    private final IBeanDecorator<T> m_interceptor;
    private final DecoratingProxy<T> m_decoratingProxy;

    public BeanProxyImplementor(IBean<T> bean, IBeanDecorator<T> interceptor, Class ... types) {
        this.m_bean = Assertions.assertNotNull(bean);
        this.m_interceptor = Assertions.assertNotNull(interceptor);
        this.m_decoratingProxy = DecoratingProxy.newInstance(this, this.m_bean::getInstance, types);
    }

    public T getProxy() {
        return this.m_decoratingProxy.getProxy();
    }

    @Override
    public Object invoke(final T instance, final Method method, final Object[] args) throws Throwable {
        IBeanInvocationContext ic = new IBeanInvocationContext<T>(){

            @Override
            public IBean<T> getTargetBean() {
                return BeanProxyImplementor.this.m_bean;
            }

            @Override
            public T getTargetObject() {
                return instance;
            }

            @Override
            public Method getTargetMethod() {
                return method;
            }

            @Override
            public Object[] getTargetArgs() {
                return args;
            }

            @Override
            public Object proceed() {
                try {
                    return method.invoke(instance, args);
                }
                catch (IllegalAccessException e) {
                    throw new ProcessingException("access denied", new Object[]{e});
                }
                catch (IllegalArgumentException e) {
                    throw new ProcessingException("argument mismatch", new Object[]{e});
                }
                catch (InvocationTargetException e) {
                    Throwable originalThrowable = BEANS.get(DefaultExceptionTranslator.class).unwrap(e);
                    if (originalThrowable instanceof Error) {
                        throw (Error)originalThrowable;
                    }
                    if (originalThrowable instanceof RuntimeException) {
                        throw (RuntimeException)originalThrowable;
                    }
                    throw new UndeclaredThrowableException(originalThrowable);
                }
            }
        };
        return this.m_interceptor.invoke(ic);
    }
}

