/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.html;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.html.IHtmlContent;
import org.eclipse.scout.rt.platform.html.IHtmlDocument;
import org.eclipse.scout.rt.platform.html.IHtmlElement;
import org.eclipse.scout.rt.platform.html.IHtmlInput;
import org.eclipse.scout.rt.platform.html.IHtmlListElement;
import org.eclipse.scout.rt.platform.html.IHtmlTable;
import org.eclipse.scout.rt.platform.html.IHtmlTableCell;
import org.eclipse.scout.rt.platform.html.IHtmlTableColgroup;
import org.eclipse.scout.rt.platform.html.IHtmlTableColgroupCol;
import org.eclipse.scout.rt.platform.html.IHtmlTableRow;
import org.eclipse.scout.rt.platform.html.internal.EmptyHtmlNodeBuilder;
import org.eclipse.scout.rt.platform.html.internal.HtmlContentBuilder;
import org.eclipse.scout.rt.platform.html.internal.HtmlDocumentBuilder;
import org.eclipse.scout.rt.platform.html.internal.HtmlImageBuilder;
import org.eclipse.scout.rt.platform.html.internal.HtmlInputBuilder;
import org.eclipse.scout.rt.platform.html.internal.HtmlLinkBuilder;
import org.eclipse.scout.rt.platform.html.internal.HtmlListElement;
import org.eclipse.scout.rt.platform.html.internal.HtmlNodeBuilder;
import org.eclipse.scout.rt.platform.html.internal.HtmlPlainBuilder;
import org.eclipse.scout.rt.platform.html.internal.HtmlTableBuilder;
import org.eclipse.scout.rt.platform.html.internal.HtmlTableColgroupBuilder;
import org.eclipse.scout.rt.platform.html.internal.HtmlTableColgroupColBuilder;
import org.eclipse.scout.rt.platform.html.internal.HtmlTableDataBuilder;
import org.eclipse.scout.rt.platform.html.internal.HtmlTableHeadBuilder;
import org.eclipse.scout.rt.platform.html.internal.HtmlTableRowBuilder;
import org.eclipse.scout.rt.platform.html.internal.StyleElementBuilder;

public final class HTML {
    private static final Pattern FONT_ICON_PATTERN = Pattern.compile("font:([^ ]+)(?:$| (.+$))");

    private HTML() {
    }

    public static IHtmlContent head(CharSequence ... elements) {
        return new HtmlNodeBuilder("head", elements);
    }

    public static IHtmlContent body(CharSequence ... elements) {
        return new HtmlNodeBuilder("body", elements);
    }

    public static IHtmlElement bold(CharSequence ... text) {
        return new HtmlNodeBuilder("b", text);
    }

    public static IHtmlElement italic(CharSequence ... text) {
        return new HtmlNodeBuilder("i", text);
    }

    public static IHtmlElement p(CharSequence ... text) {
        return new HtmlNodeBuilder("p", text);
    }

    public static IHtmlElement br() {
        return new EmptyHtmlNodeBuilder("br");
    }

    public static IHtmlElement hr() {
        return new EmptyHtmlNodeBuilder("hr");
    }

    public static IHtmlElement h1(CharSequence ... text) {
        return new HtmlNodeBuilder("h1", text);
    }

    public static IHtmlElement h2(CharSequence ... text) {
        return new HtmlNodeBuilder("h2", text);
    }

    public static IHtmlElement h3(CharSequence ... text) {
        return new HtmlNodeBuilder("h3", text);
    }

    public static IHtmlElement h4(CharSequence ... text) {
        return new HtmlNodeBuilder("h4", text);
    }

    public static IHtmlElement h5(CharSequence ... text) {
        return new HtmlNodeBuilder("h5", text);
    }

    public static IHtmlElement h6(CharSequence ... text) {
        return new HtmlNodeBuilder("h6", text);
    }

    public static IHtmlElement div(CharSequence ... content) {
        return HTML.div(Arrays.asList(content));
    }

    public static IHtmlElement div(List<CharSequence> contents) {
        return new HtmlNodeBuilder("div", contents);
    }

    public static IHtmlElement span(CharSequence ... text) {
        return new HtmlNodeBuilder("span", text);
    }

    public static IHtmlElement link(CharSequence url, CharSequence text) {
        return HTML.link(url, text, false);
    }

    public static IHtmlElement link(CharSequence url, CharSequence text, boolean preserveOpener) {
        return new HtmlLinkBuilder(url, text, preserveOpener);
    }

    public static IHtmlElement img(CharSequence src) {
        return new HtmlImageBuilder(src);
    }

    public static IHtmlElement imgByBinaryResource(CharSequence binaryResource) {
        return new HtmlImageBuilder((CharSequence)("binaryResource:" + binaryResource));
    }

    public static IHtmlElement imgByIconId(CharSequence iconId) {
        return new HtmlImageBuilder((CharSequence)("iconId:" + iconId));
    }

    public static IHtmlElement icon(CharSequence icon) {
        Matcher matcher = FONT_ICON_PATTERN.matcher(icon);
        if (matcher.find()) {
            if (matcher.group(2) == null) {
                return HTML.span(matcher.group(1)).cssClass("font-icon");
            }
            return HTML.span(matcher.group(2)).cssClass("font-" + matcher.group(1));
        }
        return HTML.imgByIconId(icon);
    }

    public static IHtmlListElement li(CharSequence text) {
        return new HtmlListElement(text);
    }

    public static IHtmlElement ul(IHtmlListElement ... li) {
        return HTML.ul(Arrays.asList(li));
    }

    public static IHtmlElement ul(List<IHtmlListElement> li) {
        return new HtmlNodeBuilder("ul", li);
    }

    public static IHtmlContent ol(IHtmlListElement ... li) {
        return new HtmlNodeBuilder("ol", (CharSequence[])li);
    }

    public static IHtmlTableColgroup colgroup(IHtmlTableColgroupCol ... cols) {
        return new HtmlTableColgroupBuilder(Arrays.asList(cols));
    }

    public static IHtmlTableColgroup colgroup(List<IHtmlTableColgroupCol> cols) {
        return new HtmlTableColgroupBuilder(cols);
    }

    public static IHtmlTableColgroupCol col() {
        return new HtmlTableColgroupColBuilder();
    }

    public static IHtmlTableCell th(CharSequence ... text) {
        return new HtmlTableHeadBuilder(Arrays.asList(text));
    }

    public static IHtmlTableCell td(CharSequence ... text) {
        return new HtmlTableDataBuilder(Arrays.asList(text));
    }

    public static IHtmlTableRow tr(IHtmlTableCell ... td) {
        return HTML.tr(Arrays.asList(td));
    }

    public static IHtmlTableRow tr(List<IHtmlTableCell> td) {
        return new HtmlTableRowBuilder((List<? extends IHtmlTableCell>)td);
    }

    public static IHtmlTable table(IHtmlTableRow ... rows) {
        return new HtmlTableBuilder(Arrays.asList(rows));
    }

    public static IHtmlTable table(List<IHtmlTableRow> rows) {
        return new HtmlTableBuilder(rows);
    }

    public static IHtmlTable table(IHtmlTableColgroup colgroup, IHtmlTableRow ... rows) {
        return new HtmlTableBuilder(colgroup, Arrays.asList(rows));
    }

    public static IHtmlTable table(IHtmlTableColgroup colgroup, List<IHtmlTableRow> rows) {
        return new HtmlTableBuilder(colgroup, rows);
    }

    public static IHtmlElement appLink(CharSequence ref, CharSequence text) {
        return HTML.span(text).appLink(ref);
    }

    public static IHtmlContent fragment(CharSequence ... elements) {
        return new HtmlContentBuilder(elements);
    }

    public static IHtmlContent fragment(List<? extends CharSequence> elements) {
        return new HtmlContentBuilder(elements);
    }

    public static IHtmlElement cssStyle(CharSequence ... cssContent) {
        return new StyleElementBuilder(cssContent).type("text/css");
    }

    public static IHtmlDocument html5(CharSequence head, CharSequence body) {
        return new HtmlDocumentBuilder(HTML.head(head), HTML.body(body)).doctype();
    }

    public static IHtmlDocument html(CharSequence head, CharSequence body) {
        return new HtmlDocumentBuilder(HTML.head(head), HTML.body(body));
    }

    public static IHtmlContent raw(CharSequence ... text) {
        return new HtmlPlainBuilder(text);
    }

    public static IHtmlInput input() {
        return new HtmlInputBuilder();
    }

    public static IHtmlElement tag(String tag, CharSequence ... text) {
        return new HtmlNodeBuilder(tag, text);
    }
}

