/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.holders;

import org.eclipse.scout.rt.platform.holders.Holder;
import org.eclipse.scout.rt.platform.holders.IHolder;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;

public final class HolderUtility {
    private HolderUtility() {
    }

    public static boolean containEqualValues(IHolder a, IHolder b) {
        Object va = a.getValue();
        Object vb = b.getValue();
        return ObjectUtility.equals(va, vb);
    }

    public static <T> void setAndCastValue(IHolder<T> h, Object value) {
        if (h != null) {
            h.setValue(TypeCastUtility.castValue(value, h.getHolderType()));
        }
    }

    public static <T> IHolder<T> createSerializableHolder(IHolder<T> h) {
        if (h == null) {
            return null;
        }
        return new Holder<T>(h.getHolderType(), h.getValue());
    }
}

