/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.holders;

import java.io.Serializable;
import org.eclipse.scout.rt.platform.holders.IHolder;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;

public class Holder<T>
implements IHolder<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private volatile T m_value;
    private final Class<T> m_clazz;

    public Holder() {
        this(null, null);
    }

    public Holder(T o) {
        this(null, o);
    }

    public Holder(Class<T> clazz) {
        this.m_clazz = clazz;
    }

    public Holder(Class<T> clazz, T o) {
        this.m_value = o;
        this.m_clazz = clazz;
    }

    @Override
    public T getValue() {
        return this.m_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(T o) {
        Holder holder = this;
        synchronized (holder) {
            this.m_value = o;
            this.notifyAll();
        }
    }

    @Override
    public Class<T> getHolderType() {
        Class clazz = this.m_clazz;
        if (clazz == null) {
            clazz = TypeCastUtility.getGenericsParameterClass(this.getClass(), IHolder.class);
        }
        return clazz;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Holder<");
        Class<T> holderType = this.getHolderType();
        if (holderType != null) {
            builder.append(holderType.getSimpleName());
        } else {
            builder.append("not available");
        }
        builder.append(">(");
        if (this.getValue() != null) {
            builder.append(this.getValue().toString());
        }
        builder.append(")");
        return builder.toString();
    }
}

