/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.exception;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.platform.exception.IThrowableWithContextInfo;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class PlatformError
extends Error
implements IThrowableWithContextInfo {
    private static final long serialVersionUID = 1L;
    private transient boolean m_consumed;
    private final List<String> m_contextInfos = new ArrayList<String>();

    public PlatformError(String message, Object ... args) {
        this(MessageFormatter.arrayFormat((String)message, (Object[])args));
    }

    protected PlatformError(FormattingTuple format) {
        super(format.getMessage(), format.getThrowable());
    }

    @Override
    public List<String> getContextInfos() {
        return CollectionUtility.arrayList(this.m_contextInfos);
    }

    @Override
    public PlatformError withContextInfo(String name, Object value, Object ... valueArgs) {
        if (value == null) {
            return this;
        }
        String valueAsString = value.toString();
        if (!StringUtility.hasText(name) || !StringUtility.hasText(valueAsString)) {
            return this;
        }
        String formattedValue = MessageFormatter.arrayFormat((String)valueAsString, (Object[])valueArgs).getMessage();
        String contextInfo = String.format("%s=%s", name, formattedValue);
        if (this.m_contextInfos.contains(contextInfo)) {
            return this;
        }
        this.m_contextInfos.add(contextInfo);
        return this;
    }

    @Override
    public boolean isConsumed() {
        return this.m_consumed;
    }

    @Override
    public void consume() {
        this.m_consumed = true;
    }

    @Override
    public String getDisplayMessage() {
        return this.extractMessageText();
    }

    @Override
    public String getMessage() {
        String msg = this.extractMessageText();
        String formattedMessage = StringUtility.hasText(msg) ? msg : "<empty>";
        String contextInfos = StringUtility.join(", ", this.getAdditionalContextInfos(), StringUtility.join(", ", this.getContextInfos()));
        if (StringUtility.isNullOrEmpty(contextInfos)) {
            return formattedMessage;
        }
        return String.format("%s [%s]", formattedMessage, contextInfos);
    }

    protected String extractMessageText() {
        return super.getMessage();
    }

    protected String getAdditionalContextInfos() {
        return null;
    }
}

