/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.dataobject;

import java.util.Optional;
import java.util.function.Consumer;

public class DoNode<T> {
    private String m_attributeName;
    private Consumer<DoNode<T>> m_lazyCreate;
    private T m_value;

    protected DoNode(String attributeName, Consumer<DoNode<T>> lazyCreate, T initialValue) {
        this.m_attributeName = attributeName;
        this.m_lazyCreate = lazyCreate;
        this.m_value = initialValue;
    }

    public final boolean exists() {
        return this.m_lazyCreate == null;
    }

    public final DoNode<T> create() {
        if (this.m_lazyCreate != null) {
            this.m_lazyCreate.accept(this);
            this.m_lazyCreate = null;
        }
        return this;
    }

    public T get() {
        return this.m_value;
    }

    public void set(T newValue) {
        this.create();
        this.m_value = newValue;
    }

    public final Optional<T> toOptional() {
        if (this.exists()) {
            return Optional.ofNullable(this.get());
        }
        return Optional.empty();
    }

    protected final void setAttributeName(String attributeName) {
        this.m_attributeName = attributeName;
    }

    public final String getAttributeName() {
        return this.m_attributeName;
    }
}

