/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.dataobject;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.dataobject.DataObjectHelper;
import org.eclipse.scout.rt.platform.dataobject.DoList;
import org.eclipse.scout.rt.platform.dataobject.DoNode;
import org.eclipse.scout.rt.platform.dataobject.DoValue;
import org.eclipse.scout.rt.platform.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.StreamUtility;

public class DoEntity
implements IDoEntity {
    private final Map<String, DoNode<?>> m_attributes = new LinkedHashMap();

    @Override
    public DoNode<?> getNode(String attributeName) {
        return this.m_attributes.get(attributeName);
    }

    @Override
    public boolean has(String attributeName) {
        return this.m_attributes.containsKey(attributeName);
    }

    @Override
    public void putNode(String attributeName, DoNode<?> attribute) {
        IDoEntity.super.putNode(attributeName, attribute);
        this.m_attributes.put(attributeName, attribute);
    }

    @Override
    public void put(String attributeName, Object value) {
        this.doValue(attributeName).set(value);
    }

    @Override
    public <V> void putList(String attributeName, List<V> value) {
        DoList<V> doList = this.doList(attributeName);
        doList.set(value);
    }

    @Override
    public void remove(String attributeName) {
        this.m_attributes.remove(attributeName);
    }

    @Override
    public void removeIf(Predicate<? super DoNode<?>> filter) {
        this.m_attributes.values().removeIf(filter);
    }

    @Override
    public Map<String, DoNode<?>> allNodes() {
        return Collections.unmodifiableMap(this.m_attributes);
    }

    @Override
    public Map<String, ?> all() {
        return this.all(Function.identity());
    }

    protected <T> Map<String, T> all(Function<Object, T> mapper) {
        return this.allNodes().entrySet().stream().collect(StreamUtility.toLinkedHashMap(Map.Entry::getKey, entry -> mapper.apply(((DoNode)entry.getValue()).get())));
    }

    protected <V> DoValue<V> doValue(String attributeName) {
        Assertions.assertNotNull(attributeName, "attribute name cannot be null", new Object[0]);
        DoNode<?> node = this.getNode(attributeName);
        if (node != null) {
            Assertions.assertInstance(node, DoValue.class, "Existing node {} is not of type {}, cannot change the node type!", node, DoValue.class);
            DoValue valueNode = (DoValue)node;
            return valueNode;
        }
        return new DoValue(attributeName, attribute -> this.putNode(attributeName, (DoNode<?>)attribute));
    }

    protected <V> DoList<V> doList(String attributeName) {
        Assertions.assertNotNull(attributeName, "attribute name cannot be null", new Object[0]);
        DoNode<?> node = this.getNode(attributeName);
        if (node != null) {
            Assertions.assertInstance(node, DoList.class, "Existing node {} is not of type {}, cannot change the node type!", node, DoList.class);
            DoList listNode = (DoList)node;
            return listNode;
        }
        return new DoList(attributeName, attribute -> this.putNode(attributeName, (DoNode<?>)attribute));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + BEANS.get(DataObjectHelper.class).toString(this);
    }
}

