/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.config;

import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.config.AbstractConfigProperty;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.StringUtility;

public abstract class AbstractPositiveLongConfigProperty
extends AbstractConfigProperty<Long, String> {
    private static final Pattern LONG_PAT = Pattern.compile("^\\d{1,18}$");

    @Override
    protected Long parse(String value) {
        if (!StringUtility.hasText(value)) {
            return null;
        }
        if (!LONG_PAT.matcher(value).matches()) {
            throw new PlatformException("Invalid long value '" + value + "' for property '" + this.getKey() + "'.", new Object[0]);
        }
        return Long.parseLong(value);
    }
}

