/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.classid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class ClassIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?>[] m_segments;
    private final int m_hash;

    public ClassIdentifier(Class<?> ... segments) {
        this((ClassIdentifier)null, segments);
    }

    public ClassIdentifier(ClassIdentifier context, Class<?> ... segments) {
        if (context == null && (segments == null || segments.length == 0)) {
            throw new IllegalArgumentException("The given context and classes array must not be null or empty");
        }
        int contextLength = context == null ? 0 : context.m_segments.length;
        int segmentsLength = segments == null ? 0 : segments.length;
        this.m_segments = new Class[contextLength + segmentsLength];
        if (context != null) {
            System.arraycopy(context.m_segments, 0, this.m_segments, 0, contextLength);
        }
        if (segments != null) {
            Class<?>[] classArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> segment = classArray[n2];
                if (segment == null) {
                    throw new IllegalArgumentException("null segments are not allowed.");
                }
                ++n2;
            }
            System.arraycopy(segments, 0, this.m_segments, contextLength, segmentsLength);
        }
        this.m_hash = Arrays.hashCode(this.m_segments);
    }

    public Class<?>[] getClasses() {
        return Arrays.copyOf(this.m_segments, this.m_segments.length);
    }

    public Class<?> getLastSegment() {
        return this.m_segments[this.m_segments.length - 1];
    }

    public Class<?> getSegment(int i) {
        if (i < 0 || i >= this.m_segments.length) {
            throw new IllegalArgumentException("index out of bounds");
        }
        return this.m_segments[i];
    }

    public int size() {
        return this.m_segments.length;
    }

    public static ClassIdentifier[] convertClassArrayToClassIdentifierArray(Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            return new ClassIdentifier[0];
        }
        ArrayList<ClassIdentifier> result = new ArrayList<ClassIdentifier>();
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (c != null) {
                result.add(new ClassIdentifier(c));
            }
            ++n2;
        }
        return result.toArray(new ClassIdentifier[result.size()]);
    }

    public int hashCode() {
        return this.m_hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassIdentifier other = (ClassIdentifier)obj;
        return Arrays.equals(this.m_segments, other.m_segments);
    }

    public String toString() {
        return "ClassIdentifier [" + Arrays.toString(this.m_segments) + "]";
    }
}

