/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

import com.googlecode.lanterna.input.KeyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class KeyStroke {
    private final KeyType keyType;
    private final Character character;
    private final boolean ctrlDown;
    private final boolean altDown;
    private final boolean shiftDown;
    private final long eventTime;

    public KeyStroke(KeyType keyType) {
        this(keyType, null, false, false, false);
    }

    public KeyStroke(KeyType keyType, boolean ctrlDown, boolean altDown) {
        this(keyType, null, ctrlDown, altDown, false);
    }

    public KeyStroke(KeyType keyType, boolean ctrlDown, boolean altDown, boolean shiftDown) {
        this(keyType, null, ctrlDown, altDown, shiftDown);
    }

    public KeyStroke(Character character, boolean ctrlDown, boolean altDown) {
        this(KeyType.Character, character, ctrlDown, altDown, false);
    }

    public KeyStroke(Character character, boolean ctrlDown, boolean altDown, boolean shiftDown) {
        this(KeyType.Character, character, ctrlDown, altDown, shiftDown);
    }

    private KeyStroke(KeyType keyType, Character character, boolean ctrlDown, boolean altDown, boolean shiftDown) {
        if (keyType == KeyType.Character && character == null) {
            throw new IllegalArgumentException("Cannot construct a KeyStroke with type KeyType.Character but no character information");
        }
        switch (keyType) {
            case Backspace: {
                character = Character.valueOf('\b');
                break;
            }
            case Enter: {
                character = Character.valueOf('\n');
                break;
            }
            case Tab: {
                character = Character.valueOf('\t');
                break;
            }
        }
        this.keyType = keyType;
        this.character = character;
        this.shiftDown = shiftDown;
        this.ctrlDown = ctrlDown;
        this.altDown = altDown;
        this.eventTime = System.currentTimeMillis();
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public Character getCharacter() {
        return this.character;
    }

    public boolean isCtrlDown() {
        return this.ctrlDown;
    }

    public boolean isAltDown() {
        return this.altDown;
    }

    public boolean isShiftDown() {
        return this.shiftDown;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("KeyStroke{keytype=").append((Object)this.keyType);
        if (this.character != null) {
            char ch = this.character.charValue();
            sb.append(", character='");
            switch (ch) {
                case '\u0000': {
                    sb.append("^@");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\u001b': {
                    sb.append("^[");
                    break;
                }
                case '\u001c': {
                    sb.append("^\\");
                    break;
                }
                case '\u001d': {
                    sb.append("^]");
                    break;
                }
                case '\u001e': {
                    sb.append("^^");
                    break;
                }
                case '\u001f': {
                    sb.append("^_");
                    break;
                }
                default: {
                    if (ch <= '\u001a') {
                        sb.append('^').append((char)(ch + 64));
                        break;
                    }
                    sb.append(ch);
                }
            }
            sb.append('\'');
        }
        if (this.ctrlDown || this.altDown || this.shiftDown) {
            String sep = "";
            sb.append(", modifiers=[");
            if (this.ctrlDown) {
                sb.append(sep).append("ctrl");
                sep = ",";
            }
            if (this.altDown) {
                sb.append(sep).append("alt");
                sep = ",";
            }
            if (this.shiftDown) {
                sb.append(sep).append("shift");
            }
            sb.append("]");
        }
        return sb.append('}').toString();
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + (this.keyType != null ? this.keyType.hashCode() : 0);
        hash = 41 * hash + (this.character != null ? this.character.hashCode() : 0);
        hash = 41 * hash + (this.ctrlDown ? 1 : 0);
        hash = 41 * hash + (this.altDown ? 1 : 0);
        hash = 41 * hash + (this.shiftDown ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyStroke other = (KeyStroke)obj;
        if (this.keyType != other.keyType) {
            return false;
        }
        if (!Objects.equals(this.character, other.character)) {
            return false;
        }
        return this.ctrlDown == other.ctrlDown && this.altDown == other.altDown && this.shiftDown == other.shiftDown;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyStroke fromString(String keyStr) {
        String keyStrLC = keyStr.toLowerCase();
        if (keyStr.length() == 1) {
            return new KeyStroke(KeyType.Character, Character.valueOf(keyStr.charAt(0)), false, false, false);
        }
        if (!keyStr.startsWith("<")) throw new IllegalArgumentException("Invalid vim notation: " + keyStr);
        if (!keyStr.endsWith(">")) throw new IllegalArgumentException("Invalid vim notation: " + keyStr);
        if (keyStrLC.equals("<s-tab>")) {
            return new KeyStroke(KeyType.ReverseTab);
        }
        if (keyStr.contains("-")) {
            ArrayList<String> segments = new ArrayList<String>(Arrays.asList(keyStr.substring(1, keyStr.length() - 1).split("-")));
            if (segments.size() < 2) {
                throw new IllegalArgumentException("Invalid vim notation: " + keyStr);
            }
            String characterStr = segments.remove(segments.size() - 1);
            boolean altPressed = false;
            boolean ctrlPressed = false;
            Iterator<String> iterator = segments.iterator();
            while (iterator.hasNext()) {
                String modifier = iterator.next();
                switch (modifier.toLowerCase()) {
                    case "c": {
                        ctrlPressed = true;
                        break;
                    }
                    case "a": {
                        altPressed = true;
                        break;
                    }
                    case "s": {
                        characterStr = characterStr.toUpperCase();
                    }
                }
            }
            return new KeyStroke(Character.valueOf(characterStr.charAt(0)), ctrlPressed, altPressed);
        }
        if (keyStrLC.startsWith("<esc")) {
            return new KeyStroke(KeyType.Escape);
        }
        if (keyStrLC.equals("<cr>")) return new KeyStroke(KeyType.Enter);
        if (keyStrLC.equals("<enter>")) return new KeyStroke(KeyType.Enter);
        if (keyStrLC.equals("<return>")) {
            return new KeyStroke(KeyType.Enter);
        }
        if (keyStrLC.equals("<bs>")) {
            return new KeyStroke(KeyType.Backspace);
        }
        if (keyStrLC.equals("<tab>")) {
            return new KeyStroke(KeyType.Tab);
        }
        if (keyStrLC.equals("<space>")) {
            return new KeyStroke(Character.valueOf(' '), false, false);
        }
        if (keyStrLC.equals("<up>")) {
            return new KeyStroke(KeyType.ArrowUp);
        }
        if (keyStrLC.equals("<down>")) {
            return new KeyStroke(KeyType.ArrowDown);
        }
        if (keyStrLC.equals("<left>")) {
            return new KeyStroke(KeyType.ArrowLeft);
        }
        if (keyStrLC.equals("<right>")) {
            return new KeyStroke(KeyType.ArrowRight);
        }
        if (keyStrLC.equals("<insert>")) {
            return new KeyStroke(KeyType.Insert);
        }
        if (keyStrLC.equals("<del>")) {
            return new KeyStroke(KeyType.Delete);
        }
        if (keyStrLC.equals("<home>")) {
            return new KeyStroke(KeyType.Home);
        }
        if (keyStrLC.equals("<end>")) {
            return new KeyStroke(KeyType.End);
        }
        if (keyStrLC.equals("<pageup>")) {
            return new KeyStroke(KeyType.PageUp);
        }
        if (keyStrLC.equals("<pagedown>")) {
            return new KeyStroke(KeyType.PageDown);
        }
        if (keyStrLC.equals("<f1>")) {
            return new KeyStroke(KeyType.F1);
        }
        if (keyStrLC.equals("<f2>")) {
            return new KeyStroke(KeyType.F2);
        }
        if (keyStrLC.equals("<f3>")) {
            return new KeyStroke(KeyType.F3);
        }
        if (keyStrLC.equals("<f4>")) {
            return new KeyStroke(KeyType.F4);
        }
        if (keyStrLC.equals("<f5>")) {
            return new KeyStroke(KeyType.F5);
        }
        if (keyStrLC.equals("<f6>")) {
            return new KeyStroke(KeyType.F6);
        }
        if (keyStrLC.equals("<f7>")) {
            return new KeyStroke(KeyType.F7);
        }
        if (keyStrLC.equals("<f8>")) {
            return new KeyStroke(KeyType.F8);
        }
        if (keyStrLC.equals("<f9>")) {
            return new KeyStroke(KeyType.F9);
        }
        if (keyStrLC.equals("<f10>")) {
            return new KeyStroke(KeyType.F10);
        }
        if (keyStrLC.equals("<f11>")) {
            return new KeyStroke(KeyType.F11);
        }
        if (!keyStrLC.equals("<f12>")) throw new IllegalArgumentException("Invalid vim notation: " + keyStr);
        return new KeyStroke(KeyType.F12);
    }

    public static class RealF3
    extends KeyStroke {
        public RealF3() {
            super(KeyType.F3, false, false, false);
        }
    }
}

