/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.menu;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.AbstractInteractableComponent;
import com.googlecode.lanterna.gui2.BasePane;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.InteractableRenderer;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.menu.Menu;
import com.googlecode.lanterna.gui2.menu.MenuBar;
import com.googlecode.lanterna.input.KeyStroke;

public class MenuItem
extends AbstractInteractableComponent<MenuItem> {
    private String label;
    private final Runnable action;

    public MenuItem(String label) {
        this(label, () -> {});
    }

    public MenuItem(String label, Runnable action) {
        this.action = action;
        if (label == null || label.trim().isEmpty()) {
            throw new IllegalArgumentException("Menu label is not allowed to be null or empty");
        }
        this.label = label.trim();
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    protected InteractableRenderer<MenuItem> createDefaultRenderer() {
        return new DefaultMenuItemRenderer();
    }

    protected boolean onActivated() {
        this.action.run();
        return true;
    }

    @Override
    protected Interactable.Result handleKeyStroke(KeyStroke keyStroke) {
        if (this.isActivationStroke(keyStroke)) {
            BasePane basePane;
            if (this.onActivated() && (basePane = this.getBasePane()) instanceof Window && ((Window)basePane).getHints().contains(Window.Hint.MENU_POPUP)) {
                ((Window)basePane).close();
            }
            return Interactable.Result.HANDLED;
        }
        if (this.isMouseMove(keyStroke)) {
            this.takeFocus();
            return Interactable.Result.HANDLED;
        }
        return super.handleKeyStroke(keyStroke);
    }

    public static class DefaultMenuItemRenderer
    extends MenuItemRenderer {
        @Override
        public TerminalPosition getCursorLocation(MenuItem component) {
            return null;
        }

        @Override
        public TerminalSize getPreferredSize(MenuItem component) {
            int preferredWidth = TerminalTextUtils.getColumnWidth(component.getLabel()) + 2;
            if (component instanceof Menu && !(component.getParent() instanceof MenuBar)) {
                preferredWidth += 2;
            }
            return TerminalSize.ONE.withColumns(preferredWidth);
        }

        @Override
        public void drawComponent(TextGUIGraphics graphics, MenuItem menuItem) {
            ThemeDefinition themeDefinition = menuItem.getThemeDefinition();
            if (menuItem.isFocused()) {
                graphics.applyThemeStyle(themeDefinition.getSelected());
            } else {
                graphics.applyThemeStyle(themeDefinition.getNormal());
            }
            String label = menuItem.getLabel();
            String leadingCharacter = label.substring(0, 1);
            graphics.fill(' ');
            graphics.putString(1, 0, label);
            if (menuItem instanceof Menu && !(menuItem.getParent() instanceof MenuBar)) {
                graphics.putString(graphics.getSize().getColumns() - 2, 0, String.valueOf('\u25ba'));
            }
            if (!label.isEmpty()) {
                if (menuItem.isFocused()) {
                    graphics.applyThemeStyle(themeDefinition.getActive());
                } else {
                    graphics.applyThemeStyle(themeDefinition.getPreLight());
                }
                graphics.putString(1, 0, leadingCharacter);
            }
        }
    }

    public static abstract class MenuItemRenderer
    implements InteractableRenderer<MenuItem> {
    }
}

