/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.dialogs;

import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.dialogs.MessageDialog;
import com.googlecode.lanterna.gui2.dialogs.MessageDialogButton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MessageDialogBuilder {
    private String title = "MessageDialog";
    private String text = "Text";
    private final List<MessageDialogButton> buttons = new ArrayList<MessageDialogButton>();
    private final Set<Window.Hint> extraWindowHints = new HashSet<Window.Hint>();

    public MessageDialogBuilder() {
        this.extraWindowHints.add(Window.Hint.CENTERED);
    }

    public MessageDialog build() {
        MessageDialog messageDialog = new MessageDialog(this.title, this.text, this.buttons.toArray(new MessageDialogButton[0]));
        messageDialog.setHints(this.extraWindowHints);
        return messageDialog;
    }

    public MessageDialogBuilder setTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.title = title;
        return this;
    }

    public MessageDialogBuilder setText(String text) {
        if (text == null) {
            text = "";
        }
        this.text = text;
        return this;
    }

    public MessageDialogBuilder setExtraWindowHints(Collection<Window.Hint> extraWindowHints) {
        this.extraWindowHints.clear();
        this.extraWindowHints.addAll(extraWindowHints);
        return this;
    }

    public MessageDialogBuilder addButton(MessageDialogButton button) {
        if (button != null) {
            this.buttons.add(button);
        }
        return this;
    }
}

